/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public SimpleIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
        String failure = "The contrived failure";
        populator.create();
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)failure, (Object)this.indexProvider.getPopulationFailure(17L));
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
        String failure = "The contrived failure";
        populator.create();
        populator.markAsFailed(failure);
        Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(17L, this.descriptor));
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
        populator.close(false);
        populator.drop();
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
        populator.create();
        populator.configureSampling(true);
        long nodeId = 1L;
        String propertyValue = "value1";
        PropertyAccessor propertyAccessor = (nodeId1, propertyKeyId) -> Property.stringProperty((int)propertyKeyId, (String)"value1");
        populator.add(Collections.singletonList(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"value1"})));
        try (IndexUpdater updater = populator.newPopulatingUpdater(propertyAccessor);){
            updater.process(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"value1"}));
        }
        populator.close(true);
        IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);
        try (IndexReader reader = accessor.newReader();){
            int propertyKeyId2 = this.descriptor.schema().getPropertyId();
            PrimitiveLongIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)propertyKeyId2, (Object)"value1")});
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
        }
        accessor.close();
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexPopulatorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
            String value = "value1";
            int nodeId1 = 1;
            int nodeId2 = 2;
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
            IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
            populator.create();
            populator.add(Arrays.asList(IndexEntryUpdate.add((long)nodeId1, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{value}), IndexEntryUpdate.add((long)nodeId2, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{value})));
            try {
                NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(nodeId1, this.descriptor.schema(), value);
                propertyAccessor.addNode(nodeId2, this.descriptor.schema(), value);
                populator.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
                Assert.fail((String)"expected exception");
            }
            catch (IndexEntryConflictException conflict) {
                Assert.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
                Assert.assertEquals((Object)OrderedPropertyValues.ofUndefined((Object[])new Object[]{value}), (Object)conflict.getPropertyValues());
                Assert.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
            }
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.empty());
            IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
            populator.create();
            populator.add(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"value1"}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Object[])new Object[]{"value1"})));
            populator.close(true);
            IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);
            try (IndexReader reader = accessor.newReader();){
                PrimitiveLongIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)"value1")});
                Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
            }
            accessor.close();
        }
    }
}

