/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthToken;

public class AuthTokenTest {
    @Test
    public void shouldMakeBasicAuthToken() throws Exception {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)"my secret"));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have no realm", token.get("realm"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldMakeBasicAuthTokenWithRealm() throws Exception {
        Map token = AuthToken.newBasicAuthToken((String)"me", (String)"my secret", (String)"my realm");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)"my secret"));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    public void shouldMakeCustomAuthTokenAndBasicScheme() throws Exception {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"basic");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)"my secret"));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"basic"));
        MatcherAssert.assertThat((String)"Should have correctno realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    public void shouldMakeCustomAuthTokenAndCustomcScheme() throws Exception {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme");
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)"my secret"));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"my scheme"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
    }

    @Test
    public void shouldMakeCustomAuthTokenAndCustomcSchemeWithParameters() throws Exception {
        Map token = AuthToken.newCustomAuthToken((String)"me", (String)"my secret", (String)"my realm", (String)"my scheme", (Map)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"}));
        MatcherAssert.assertThat((String)"Should have correct username", token.get("principal"), (Matcher)Matchers.equalTo((Object)"me"));
        MatcherAssert.assertThat((String)"Should have correct password", token.get("credentials"), (Matcher)Matchers.equalTo((Object)"my secret"));
        MatcherAssert.assertThat((String)"Should have correct scheme", token.get("scheme"), (Matcher)Matchers.equalTo((Object)"my scheme"));
        MatcherAssert.assertThat((String)"Should have correct realm", token.get("realm"), (Matcher)Matchers.equalTo((Object)"my realm"));
        MatcherAssert.assertThat((String)"Should have correct parameters", token.get("parameters"), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"})));
    }
}

