/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.builtinprocs.IndexSpecifier;

public class IndexSpecifierTest {
    @Test
    public void shouldFormatAsCanonicalRepresentation() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(name)").toString(), (Matcher)Matchers.is((Object)":Person(name)"));
    }

    @Test
    public void shouldParseASimpleLabel() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person_23(name)").label(), (Matcher)Matchers.is((Object)"Person_23"));
    }

    @Test
    public void shouldParseASimpleProperty() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(a_Name_123)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"a_Name_123"})));
    }

    @Test
    public void shouldParseTwoProperties() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(name, lastName)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"name", "lastName"})));
    }

    @Test
    public void shouldParseManyProperties() {
        String[] properties = new IndexSpecifier(":Person(1, 2, 3, 4, 5, 6)").properties();
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2", "3", "4", "5", "6"})));
    }

    @Test
    public void shouldParseOddProperties() {
        String[] properties = new IndexSpecifier(": Person(1,    2lskgj_LKHGS, `3sdlkhs,   df``sas;g`, 4, `  5  `, 6)").properties();
        MatcherAssert.assertThat((Object)properties, (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"1", "2lskgj_LKHGS", "3sdlkhs,   df``sas;g", "4", "  5  ", "6"})));
    }

    @Test
    public void shouldParseANastyLabel() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":`:(!\"\u00a3$%^&*( )`(name)").label(), (Matcher)Matchers.is((Object)":(!\"\u00a3$%^&*( )"));
    }

    @Test
    public void shouldParseANastyProperty() {
        MatcherAssert.assertThat((Object)new IndexSpecifier(":Person(`(:!\"\u00a3$%^&*( )`)").properties(), (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{"(:!\"\u00a3$%^&*( )"})));
    }

    @Test
    public void shouldProduceAReasonableErrorIfTheSpecificationCantBeParsed() {
        try {
            new IndexSpecifier("rubbish");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

