/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.IndividualSettingsValidator;
import org.neo4j.logging.Log;

public class IndividualSettingsValidatorTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Log log;

    @Before
    public void setup() {
        this.log = (Log)Mockito.mock(Log.class);
    }

    @Test
    public void nonStrictRetainsSettings() throws Exception {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(true);
        Map fullConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "false", "dbms.jibber.jabber", "bla", "external_plugin.foo", "bar"});
        Map result = iv.validate(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), fullConfig, this.log, false);
        Assert.assertEquals((Object)fullConfig, (Object)result);
        ((Log)Mockito.verify((Object)this.log)).warn("Unknown config option: %s", new Object[]{"dbms.jibber.jabber"});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
    }

    @Test
    public void strictErrorsOnUnknownSettingsInOurNamespace() throws Exception {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(true);
        Map fullConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "true", "dbms.jibber.jabber", "bla", "external_plugin.foo", "bar"});
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage(String.format("Unknown config option 'dbms.jibber.jabber'. To resolve either remove it from your configuration or set '%s' to false.", GraphDatabaseSettings.strict_config_validation.name()));
        iv.validate(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), fullConfig, this.log, false);
    }

    @Test
    public void strictAllowsStuffOutsideOurNamespace() throws Exception {
        IndividualSettingsValidator iv = new IndividualSettingsValidator(true);
        Map fullConfig = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.strict_config_validation.name(), "true", "external_plugin.foo", "bar"});
        Map result = iv.validate(Collections.singletonList(GraphDatabaseSettings.strict_config_validation), fullConfig, this.log, false);
        Assert.assertEquals((Object)fullConfig, (Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.log});
    }
}

