/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.test.rule.TestDirectory;

public class SslPolicyLoaderTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private File home;
    private File publicCertificateFile;
    private File privateKeyFile;

    @Before
    public void setup() throws Exception {
        this.home = this.testDirectory.directory("home");
        File baseDir = new File(this.home, "certificates/default");
        this.publicCertificateFile = new File(baseDir, "public.crt");
        this.privateKeyFile = new File(baseDir, "private.key");
        new PkiUtils().createSelfSignedCertificate(this.publicCertificateFile, this.privateKeyFile, "localhost");
        File trustedDir = new File(baseDir, "trusted");
        trustedDir.mkdir();
        FileUtils.copyFile((File)this.publicCertificateFile, (File)new File(trustedDir, "public.crt"));
        new File(baseDir, "revoked").mkdir();
    }

    @Test
    public void shouldLoadBaseCryptographicObjects() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        SslPolicyConfig policyConfig = new SslPolicyConfig("default");
        params.put(GraphDatabaseSettings.neo4j_home.name(), this.home.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/default");
        config.augment(params);
        SslPolicyLoader sslPolicyLoader = SslPolicyLoader.create((Config)config, (LogProvider)NullLogProvider.getInstance());
        SslPolicy sslPolicy = sslPolicyLoader.getPolicy("default");
        Assert.assertNotNull((Object)sslPolicy);
        Assert.assertNotNull((Object)sslPolicy.privateKey());
        Assert.assertNotNull((Object)sslPolicy.certificateChain());
        Assert.assertNotNull((Object)sslPolicy.nettyClientContext());
        Assert.assertNotNull((Object)sslPolicy.nettyServerContext());
    }

    @Test
    public void shouldComplainIfMissingPrivateKey() throws Exception {
        this.shouldComplainIfMissingFile(this.privateKeyFile);
    }

    @Test
    public void shouldComplainIfMissingPublicCertificate() throws Exception {
        this.shouldComplainIfMissingFile(this.publicCertificateFile);
    }

    private void shouldComplainIfMissingFile(File file) throws Exception {
        FileUtils.deleteFile((File)file);
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        SslPolicyConfig policyConfig = new SslPolicyConfig("default");
        params.put(GraphDatabaseSettings.neo4j_home.name(), this.home.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/default");
        config.augment(params);
        try {
            SslPolicyLoader.create((Config)config, (LogProvider)NullLogProvider.getInstance());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof FileNotFoundException));
        }
    }

    @Test
    public void shouldThrowIfPolicyNameDoesNotExist() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        SslPolicyConfig policyConfig = new SslPolicyConfig("default");
        params.put(GraphDatabaseSettings.neo4j_home.name(), this.home.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/default");
        config.augment(params);
        SslPolicyLoader sslPolicyLoader = SslPolicyLoader.create((Config)config, (LogProvider)NullLogProvider.getInstance());
        try {
            sslPolicyLoader.getPolicy("unknown");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnNullPolicyIfNullRequested() throws Exception {
        SslPolicyLoader sslPolicyLoader = SslPolicyLoader.create((Config)Config.empty(), (LogProvider)NullLogProvider.getInstance());
        SslPolicy sslPolicy = sslPolicyLoader.getPolicy(null);
        Assert.assertNull((Object)sslPolicy);
    }

    @Test
    public void shouldNotAllowLegacyPolicyToBeConfigured() throws Exception {
        Config config = Config.empty();
        Map params = MapUtil.stringMap((String[])new String[0]);
        SslPolicyConfig policyConfig = new SslPolicyConfig("legacy");
        params.put(GraphDatabaseSettings.neo4j_home.name(), this.home.getAbsolutePath());
        params.put(policyConfig.base_directory.name(), "certificates/default");
        config.augment(params);
        try {
            SslPolicyLoader.create((Config)config, (LogProvider)NullLogProvider.getInstance());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

