/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;

public class DiffSetsTest {
    private static final Predicate<Long> ODD_FILTER = item -> item % 2L == 1L;

    @Test
    public void testAdd() {
        DiffSets actual = new DiffSets();
        actual.add((Object)1L);
        actual.add((Object)2L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)actual.getAdded());
        Assert.assertTrue((boolean)actual.getRemoved().isEmpty());
    }

    @Test
    public void testRemove() {
        DiffSets actual = new DiffSets();
        actual.add((Object)1L);
        actual.remove((Object)2L);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)actual.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), (Object)actual.getRemoved());
    }

    @Test
    public void testAddRemove() {
        DiffSets actual = new DiffSets();
        actual.add((Object)1L);
        actual.remove((Object)1L);
        Assert.assertTrue((boolean)actual.getAdded().isEmpty());
        Assert.assertTrue((boolean)actual.getRemoved().isEmpty());
    }

    @Test
    public void testRemoveAdd() {
        DiffSets actual = new DiffSets();
        actual.remove((Object)1L);
        actual.add((Object)1L);
        Assert.assertTrue((boolean)actual.getAdded().isEmpty());
        Assert.assertTrue((boolean)actual.getRemoved().isEmpty());
    }

    @Test
    public void testIsAddedOrRemoved() {
        DiffSets actual = new DiffSets();
        actual.add((Object)1L);
        actual.remove((Object)10L);
        Assert.assertTrue((boolean)actual.isAdded((Object)1L));
        Assert.assertTrue((!actual.isAdded((Object)2L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)actual.isRemoved((Object)10L));
        Assert.assertTrue((!actual.isRemoved((Object)2L) ? 1 : 0) != 0);
    }

    @Test
    public void testAddRemoveAll() {
        DiffSets actual = new DiffSets();
        actual.addAll(Iterators.iterator((Object[])new Long[]{1L, 2L}));
        actual.removeAll(Iterators.iterator((Object[])new Long[]{2L, 3L}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)actual.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L}), (Object)actual.getRemoved());
    }

    @Test
    public void testFilterAdded() {
        DiffSets actual = new DiffSets();
        actual.addAll(Iterators.iterator((Object[])new Long[]{1L, 2L}));
        actual.removeAll(Iterators.iterator((Object[])new Long[]{3L, 4L}));
        DiffSets filtered = actual.filterAdded(ODD_FILTER);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)filtered.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L, 4L}), (Object)filtered.getRemoved());
    }

    @Test
    public void testReturnSourceFromApplyWithEmptyDiffSets() throws Exception {
        DiffSets diffSets = new DiffSets();
        Iterator result = diffSets.apply(Arrays.asList(18L).iterator());
        Assert.assertEquals(Arrays.asList(18L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testAppendAddedToSourceInApply() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.add((Object)52L);
        diffSets.remove((Object)43L);
        Iterator result = diffSets.apply(Arrays.asList(18L).iterator());
        Assert.assertEquals(Arrays.asList(18L, 52L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testFilterRemovedFromSourceInApply() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.remove((Object)43L);
        Iterator result = diffSets.apply(Arrays.asList(42L, 43L, 44L).iterator());
        Assert.assertEquals(Arrays.asList(42L, 44L), (Object)Iterators.asCollection((Iterator)result));
    }

    @Test
    public void testFilterAddedFromSourceInApply() throws Exception {
        DiffSets diffSets = new DiffSets();
        diffSets.add((Object)42L);
        diffSets.add((Object)44L);
        Iterator result = diffSets.apply(Arrays.asList(42L, 43L).iterator());
        Collection collectedResult = Iterators.asCollection((Iterator)result);
        Assert.assertEquals((long)3L, (long)collectedResult.size());
        MatcherAssert.assertThat((Object)collectedResult, (Matcher)IsCollectionContaining.hasItems((Object[])new Long[]{43L, 42L, 44L}));
    }

    @Test
    public void replaceMultipleTimesWithAnInitialValue() throws Exception {
        DiffSets diff = new DiffSets();
        diff.add((Object)0);
        diff.replace((Object)0, (Object)1);
        diff.replace((Object)1, (Object)2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{2}), (Object)diff.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)diff.getRemoved());
    }

    @Test
    public void replaceMultipleTimesWithNoInitialValue() throws Exception {
        DiffSets diff = new DiffSets();
        diff.replace((Object)0, (Object)1);
        diff.replace((Object)1, (Object)2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{2}), (Object)diff.getAdded());
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Integer[]{0}), (Object)diff.getRemoved());
    }
}

