/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.KernelTransactionMonitorScheduler;
import org.neo4j.kernel.impl.api.KernelTransactionTimeoutMonitor;
import org.neo4j.kernel.impl.util.JobScheduler;

public class KernelTransactionMonitorSchedulerTest {
    private final JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final KernelTransactionTimeoutMonitor transactionTimeoutMonitor = (KernelTransactionTimeoutMonitor)Mockito.mock(KernelTransactionTimeoutMonitor.class);

    @Test
    public void scheduleRecurringMonitorJobIfConfigured() throws Throwable {
        KernelTransactionMonitorScheduler transactionMonitorScheduler = this.createMonitorScheduler(1L);
        transactionMonitorScheduler.start();
        ((JobScheduler)Mockito.verify((Object)this.scheduler)).scheduleRecurring(JobScheduler.Groups.transactionTimeoutMonitor, (Runnable)this.transactionTimeoutMonitor, 1L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void doNotScheduleMonitorJobIfDisabled() throws Throwable {
        KernelTransactionMonitorScheduler transactionMonitorScheduler = this.createMonitorScheduler(0L);
        transactionMonitorScheduler.start();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.scheduler});
    }

    private KernelTransactionMonitorScheduler createMonitorScheduler(long checkInterval) {
        return new KernelTransactionMonitorScheduler(this.transactionTimeoutMonitor, this.scheduler, checkInterval);
    }
}

