/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class ConstraintIndexCreatorTest {
    private static final int PROPERTY_KEY_ID = 456;
    private static final int LABEL_ID = 123;
    private final LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)123, (int[])new int[]{456});
    private final IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)123, (int[])new int[]{456});

    @Test
    public void shouldCreateIndexInAnotherTransaction() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, this.index)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetForSchema(state, this.descriptor)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, false);
        long indexId = creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), this.descriptor);
        Assert.assertEquals((long)2468L, (long)indexId);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).indexRuleDoAdd((IndexDescriptor)Matchers.eq((Object)this.index));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, this.index);
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetForSchema(state, this.descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldDropIndexIfPopulationFails() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, this.index)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(2468L)).thenReturn((Object)indexProxy);
        IndexEntryConflictException cause = new IndexEntryConflictException(2L, 1L, new Object[]{"a"});
        ((IndexProxy)Mockito.doThrow((Throwable)new IndexPopulationFailedKernelException(this.descriptor, "some index", (Throwable)cause)).when((Object)indexProxy)).awaitStoreScanCompleted();
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetForSchema(state, this.descriptor)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, false);
        try {
            creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), this.descriptor);
            Assert.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertEquals((Object)"Existing data does not satisfy CONSTRAINT ON ( label[123]:label[123] ) ASSERT label[123].property[456] IS UNIQUE.", (Object)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)kernel.statements.size());
        TransactionState tx1 = ((KernelStatement)kernel.statements.get(0)).txState();
        IndexDescriptor newIndex = IndexDescriptorFactory.uniqueForLabel((int)123, (int[])new int[]{456});
        ((TransactionState)Mockito.verify((Object)tx1)).indexRuleDoAdd(newIndex);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx1});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, this.index);
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetForSchema(state, this.descriptor);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        TransactionState tx2 = ((KernelStatement)kernel.statements.get(1)).txState();
        ((TransactionState)Mockito.verify((Object)tx2)).indexDoDrop(newIndex);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx2});
    }

    @Test
    public void shouldDropIndexInAnotherTransaction() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, false);
        creator.dropUniquenessConstraintIndex(this.index);
        Assert.assertEquals((long)1L, (long)kernel.statements.size());
        ((TransactionState)Mockito.verify((Object)((KernelStatement)kernel.statements.get(0)).txState())).indexDoDrop(this.index);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexingService});
    }

    @Test
    public void shouldReleaseSchemaLockWhileAwaitingIndexPopulation() throws Exception {
        StubKernel kernel = new StubKernel();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, this.index)).thenReturn((Object)2468L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(Matchers.anyLong())).thenReturn((Object)indexProxy);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetForSchema(state, this.descriptor)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, true);
        creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), this.descriptor);
        ((Locks.Client)Mockito.verify((Object)state.locks().pessimistic())).releaseExclusive((ResourceType)ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        ((Locks.Client)Mockito.verify((Object)state.locks().pessimistic())).acquireExclusive(state.lockTracer(), (ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
    }

    @Test
    public void shouldReuseExistingOrphanedConstraintIndex() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long orphanedConstraintIndexId = 111L;
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, this.index)).thenReturn((Object)orphanedConstraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(orphanedConstraintIndexId)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetForSchema(state, this.descriptor)).thenReturn((Object)this.index);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetOwningUniquenessConstraintId(state, this.index)).thenReturn(null);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, false);
        long indexId = creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), this.descriptor);
        Assert.assertEquals((long)orphanedConstraintIndexId, (long)indexId);
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.statements.size());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetCommittedId(state, this.index);
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetForSchema(state, this.descriptor);
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetOwningUniquenessConstraintId(state, this.index);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
        ((IndexProxy)Mockito.verify((Object)indexProxy)).awaitStoreScanCompleted();
    }

    @Test
    public void shouldFailOnExistingOwnedConstraintIndex() throws Exception {
        StatementOperationParts constraintCreationContext = StatementOperationsTestHelper.mockedParts();
        StatementOperationParts indexCreationContext = StatementOperationsTestHelper.mockedParts();
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        StubKernel kernel = new StubKernel();
        long constraintIndexId = 111L;
        long constraintIndexOwnerId = 222L;
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetCommittedId(state, this.index)).thenReturn((Object)constraintIndexId);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexingService.getIndexProxy(constraintIndexId)).thenReturn((Object)indexProxy);
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetForSchema(state, this.descriptor)).thenReturn((Object)this.index);
        Mockito.when((Object)constraintCreationContext.schemaReadOperations().indexGetOwningUniquenessConstraintId(state, this.index)).thenReturn((Object)constraintIndexOwnerId);
        Mockito.when((Object)state.readOperations().labelGetName(123)).thenReturn((Object)"MyLabel");
        Mockito.when((Object)state.readOperations().propertyKeyGetName(456)).thenReturn((Object)"MyKey");
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> kernel, indexingService, propertyAccessor, false);
        try {
            creator.createUniquenessConstraintIndex(state, constraintCreationContext.schemaReadOperations(), this.descriptor);
            Assert.fail((String)"Should've failed");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        Assert.assertEquals((String)"There should have been no need to acquire a statement to create the constraint index", (long)0L, (long)kernel.statements.size());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{indexCreationContext.schemaWriteOperations()});
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetForSchema(state, this.descriptor);
        ((SchemaReadOperations)Mockito.verify((Object)constraintCreationContext.schemaReadOperations())).indexGetOwningUniquenessConstraintId(state, this.index);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{constraintCreationContext.schemaReadOperations()});
    }

    private class StubKernel
    implements KernelAPI {
        private final List<KernelStatement> statements = new ArrayList<KernelStatement>();

        private StubKernel() {
        }

        public KernelTransaction newTransaction(KernelTransaction.Type type, SecurityContext securityContext) {
            return new StubKernelTransaction();
        }

        public KernelTransaction newTransaction(KernelTransaction.Type type, SecurityContext securityContext, long timeout) throws TransactionFailureException {
            return new StubKernelTransaction(timeout);
        }

        public void registerTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public void unregisterTransactionHook(TransactionHook hook) {
            throw new UnsupportedOperationException("Please implement");
        }

        public void registerProcedure(CallableProcedure procedure) {
            throw new UnsupportedOperationException();
        }

        public void registerUserFunction(CallableUserFunction function) throws ProcedureException {
            throw new UnsupportedOperationException();
        }

        public void registerUserAggregationFunction(CallableUserAggregationFunction function) throws ProcedureException {
            throw new UnsupportedOperationException();
        }

        private class StubKernelTransaction
        implements KernelTransaction {
            private long timeout = 0L;

            StubKernelTransaction() {
            }

            StubKernelTransaction(long timeout) {
                this.timeout = timeout;
            }

            public void success() {
            }

            public void failure() {
            }

            public long closeTransaction() throws TransactionFailureException {
                return -1L;
            }

            public Statement acquireStatement() {
                return this.remember(StatementOperationsTestHelper.mockedState());
            }

            private Statement remember(KernelStatement mockedState) {
                StubKernel.this.statements.add(mockedState);
                return mockedState;
            }

            public boolean isOpen() {
                return true;
            }

            public SecurityContext securityContext() {
                throw new UnsupportedOperationException();
            }

            public Optional<Status> getReasonIfTerminated() {
                return null;
            }

            public void markForTermination(Status reason) {
            }

            public long lastTransactionTimestampWhenStarted() {
                return 0L;
            }

            public void registerCloseListener(KernelTransaction.CloseListener listener) {
            }

            public KernelTransaction.Type transactionType() {
                return null;
            }

            public long getTransactionId() {
                return -1L;
            }

            public long getCommitTime() {
                return -1L;
            }

            public KernelTransaction.Revertable overrideWith(SecurityContext context) {
                return null;
            }

            public long lastTransactionIdWhenStarted() {
                return 0L;
            }

            public long startTime() {
                return 0L;
            }

            public long timeout() {
                return this.timeout;
            }
        }
    }
}

