/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.cursor.TxSingleNodeCursor;
import org.neo4j.kernel.impl.util.Cursors;

public class TxSingleNodeCursorTest {
    private final TransactionState state = (TransactionState)Mockito.mock(TransactionState.class);
    private TxSingleNodeCursor cursor = new TxSingleNodeCursor(this.state, l -> {});

    @Test
    public void shouldNotLoopForeverWhenNodesAreAddedToTheTxState() throws Exception {
        int nodeId = 42;
        Mockito.when((Object)this.state.nodeIsDeletedInThisTx((long)nodeId)).thenReturn((Object)false);
        Mockito.when((Object)this.state.nodeIsAddedInThisTx((long)nodeId)).thenReturn((Object)true);
        this.cursor.init(Cursors.empty(), (long)nodeId);
        Assert.assertTrue((boolean)this.cursor.next());
        Assert.assertFalse((boolean)this.cursor.next());
    }
}

