/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;

public class IndexIT
extends KernelIntegrationTest {
    private static final String LABEL = "Label";
    private static final String PROPERTY_KEY = "prop";
    private static final String PROPERTY_KEY2 = "prop2";
    private int labelId;
    private int propertyKeyId;
    private LabelSchemaDescriptor descriptor;
    private LabelSchemaDescriptor descriptor2;

    @Before
    public void createLabelAndProperty() throws Exception {
        TokenWriteOperations tokenWrites = this.tokenWriteOperationsInNewTransaction();
        this.labelId = tokenWrites.labelGetOrCreateForName(LABEL);
        this.propertyKeyId = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY);
        int propertyKeyId2 = tokenWrites.propertyKeyGetOrCreateForName(PROPERTY_KEY2);
        this.descriptor = SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{this.propertyKeyId});
        this.descriptor2 = SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{propertyKeyId2});
        this.commit();
    }

    @Test
    public void addIndexRuleInATransaction() throws Exception {
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor expectedRule = schemaWriteOperations.indexCreate(this.descriptor);
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{expectedRule}), (Object)Iterators.asSet((Iterator)readOperations.indexesGetForLabel(this.labelId)));
        Assert.assertEquals((Object)expectedRule, (Object)readOperations.indexGetForSchema(this.descriptor));
        this.commit();
    }

    @Test
    public void committedAndTransactionalIndexRulesShouldBeMerged() throws Exception {
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor existingRule = schemaWriteOperations.indexCreate(this.descriptor);
        this.commit();
        Statement statement = this.statementInNewTransaction(AnonymousContext.AUTH_DISABLED);
        IndexDescriptor addedRule = statement.schemaWriteOperations().indexCreate(SchemaDescriptorFactory.forLabel((int)this.labelId, (int[])new int[]{10}));
        Set indexRulesInTx = Iterators.asSet((Iterator)statement.readOperations().indexesGetForLabel(this.labelId));
        this.commit();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{existingRule, addedRule}), (Object)indexRulesInTx);
    }

    @Test
    public void rollBackIndexRuleShouldNotBeCommitted() throws Exception {
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        schemaWriteOperations.indexCreate(this.descriptor);
        this.rollback();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.emptySetOf(IndexDescriptor.class), (Object)Iterators.asSet((Iterator)readOperations.indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldBeAbleToRemoveAConstraintIndexWithoutOwner() throws Exception {
        PropertyAccessor propertyAccessor = (PropertyAccessor)Mockito.mock(PropertyAccessor.class);
        ConstraintIndexCreator creator = new ConstraintIndexCreator(() -> this.kernel, this.indexingService, propertyAccessor, false);
        IndexDescriptor constraintIndex = creator.createConstraintIndex(this.descriptor);
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.emptySetOf(ConstraintDescriptor.class), (Object)Iterators.asSet((Iterator)readOperations.constraintsGetForLabel(this.labelId)));
        this.commit();
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        schemaWriteOperations.indexDrop(constraintIndex);
        this.commit();
        readOperations = this.readOperationsInNewTransaction();
        Assert.assertEquals((Object)Iterators.emptySetOf(IndexDescriptor.class), (Object)Iterators.asSet((Iterator)readOperations.indexesGetForLabel(this.labelId)));
        this.commit();
    }

    @Test
    public void shouldDisallowDroppingIndexThatDoesNotExist() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor index = statement.indexCreate(this.descriptor);
        this.commit();
        statement = this.schemaWriteOperationsInNewTransaction();
        statement.indexDrop(index);
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.indexDrop(index);
            this.commit();
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)("Unable to drop index on :label[" + this.labelId + "](property[" + this.propertyKeyId + "]): No such INDEX ON :label[" + this.labelId + "](property[" + this.propertyKeyId + "])."), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldFailToCreateIndexWhereAConstraintAlreadyExists() throws Exception {
        SchemaWriteOperations statement = this.schemaWriteOperationsInNewTransaction();
        statement.uniquePropertyConstraintCreate(this.descriptor);
        this.commit();
        try {
            statement = this.schemaWriteOperationsInNewTransaction();
            statement.indexCreate(this.descriptor);
            this.commit();
            Assert.fail((String)"expected exception");
        }
        catch (SchemaKernelException e) {
            Assert.assertEquals((Object)"Label 'Label' and property 'prop' have a unique constraint defined on them, so an index is already created that matches this.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldListConstraintIndexesInTheBeansAPI() throws Exception {
        Statement statement = this.statementInNewTransaction(SecurityContext.AUTH_DISABLED);
        statement.schemaWriteOperations().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)statement.tokenWriteOperations().labelGetOrCreateForName("Label1"), (int[])new int[]{statement.tokenWriteOperations().propertyKeyGetOrCreateForName("property1")}));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            Set indexes = Iterables.asSet((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((long)1L, (long)indexes.size());
            IndexDefinition index = (IndexDefinition)indexes.iterator().next();
            Assert.assertEquals((Object)"Label1", (Object)index.getLabel().name());
            Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"property1"}), (Object)Iterables.asSet((Iterable)index.getPropertyKeys()));
            Assert.assertTrue((String)"index should be a constraint index", (boolean)index.isConstraintIndex());
            try {
                index.drop();
                Assert.fail((String)"expected exception");
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)"Constraint indexes cannot be dropped directly, instead drop the owning uniqueness constraint.", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void shouldListAll() throws Exception {
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        IndexDescriptor index1 = schemaWriteOperations.indexCreate(this.descriptor);
        IndexDescriptor index2 = schemaWriteOperations.uniquePropertyConstraintCreate(this.descriptor2).ownedIndexDescriptor();
        this.commit();
        ReadOperations readOperations = this.readOperationsInNewTransaction();
        List indexes = Iterators.asList((Iterator)readOperations.indexesGetAll());
        MatcherAssert.assertThat((Object)indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexDescriptor[]{index1, index2}));
    }
}

