/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.TokenWriteOperations;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class UniquenessConstraintValidationIT
extends KernelIntegrationTest {
    @Test
    public void shouldEnforceOnSetProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long node = this.createLabeledNode(statement, "Label1");
        try {
            statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)statement.tokenWriteOperations().propertyKeyGetOrCreateForName("key1"), (Object)"value1"));
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value1'"));
        }
    }

    @Test
    public void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
        long propertyValue = 285414114323346805L;
        long firstNode = this.constrainedNode("label1", "key1", propertyValue);
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long node = this.createLabeledNode(statement, "label1");
        Assert.assertNotEquals((long)firstNode, (long)node);
        DefinedProperty prop = Property.property((int)statement.tokenWriteOperations().propertyKeyGetOrCreateForName("key1"), (Object)(++propertyValue));
        statement.dataWriteOperations().nodeSetProperty(node, prop);
        this.commit();
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabelForNumberPropertyOnNodeNotFromTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", 1);
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long node = this.createNode(statement, "key1", 1);
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        try {
            int label = statement.tokenWriteOperations().labelGetOrCreateForName("Label1");
            statement.dataWriteOperations().nodeAddLabel(node, label);
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"`key1` = 1"));
        }
    }

    @Test
    public void shouldEnforceUniquenessConstraintOnAddLabelForStringProperty() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long node = this.createNode(statement, "key1", "value1");
        try {
            int label = statement.tokenWriteOperations().labelGetOrCreateForName("Label1");
            statement.dataWriteOperations().nodeAddLabel(node, label);
            Assert.fail((String)"should have thrown exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value1'"));
        }
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        statement.dataWriteOperations().nodeDelete(node);
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int label = statement.tokenWriteOperations().labelGetOrCreateForName("Label1");
        statement.dataWriteOperations().nodeRemoveLabel(node, label);
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int key = statement.readOperations().propertyKeyGetForName("key1");
        statement.dataWriteOperations().nodeRemoveProperty(node, key);
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int key = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("key1");
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)key, (Object)"value2"));
        this.createLabeledNode(statement, "Label1", "key1", "value1");
        this.commit();
    }

    @Test
    public void shouldPreventConflictingDataInSameTransaction() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        this.createLabeledNode(statement, "Label1", "key1", "value2");
        try {
            this.createLabeledNode(statement, "Label1", "key1", "value2");
            Assert.fail((String)"expected exception");
        }
        catch (UniquePropertyValueValidationException e) {
            Assert.assertThat((Object)e.getUserMessage(this.tokenLookup(statement)), (Matcher)CoreMatchers.containsString((String)"`key1` = 'value2'"));
        }
    }

    @Test
    public void shouldAllowNoopPropertyUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int key = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("key1");
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)key, (Object)"value1"));
    }

    @Test
    public void shouldAllowNoopLabelUpdate() throws KernelException {
        long node = this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int label = statement.tokenWriteOperations().labelGetOrCreateForName("Label1");
        statement.dataWriteOperations().nodeAddLabel(node, label);
    }

    @Test
    public void shouldAllowCreationOfNonConflictingData() throws Exception {
        this.constrainedNode("Label1", "key1", "value1");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        this.createNode(statement, "key1", "value1");
        this.createLabeledNode(statement, "Label2", "key1", "value1");
        this.createLabeledNode(statement, "Label1", "key1", "value2");
        this.createLabeledNode(statement, "Label1", "key2", "value1");
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        Assert.assertEquals((String)"number of nodes", (long)5L, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)statement.readOperations().nodesGetAll()));
        this.rollback();
    }

    @Test
    public void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
        this.createConstraint("Person", "id");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long ourNode = this.createLabeledNode(statement, "Person", "id", 1);
        this.createLabeledNode(statement, "Item", "id", 2);
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        ReadOperations readOps = statement.readOperations();
        int person = readOps.labelGetForName("Person");
        int propId = readOps.propertyKeyGetForName("id");
        IndexDescriptor idx = readOps.indexGetForSchema(SchemaDescriptorFactory.forLabel((int)person, (int[])new int[]{propId}));
        this.createLabeledNode(statement, "Item", "id", 2);
        Assert.assertThat((Object)readOps.nodeGetFromUniqueIndexSeek(idx, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)1)}), (Matcher)Matchers.equalTo((Object)ourNode));
    }

    @Test
    public void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
        this.createConstraint("Person", "id");
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        long ourNode = this.createLabeledNode(statement, "Person", "id", 1);
        this.commit();
        statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        ReadOperations readOps = statement.readOperations();
        int person = readOps.labelGetForName("Person");
        int propId = readOps.propertyKeyGetForName("id");
        IndexDescriptor idx = readOps.indexGetForSchema(SchemaDescriptorFactory.forLabel((int)person, (int[])new int[]{propId}));
        this.createLabeledNode(statement, "Person", "id", 2);
        Assert.assertThat((Object)readOps.nodeGetFromUniqueIndexSeek(idx, new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)propId, (Object)1)}), (Matcher)Matchers.equalTo((Object)ourNode));
    }

    private TokenNameLookup tokenLookup(Statement statement) {
        return new StatementTokenNameLookup(statement.readOperations());
    }

    private long createLabeledNode(Statement statement, String label) throws KernelException {
        long node = statement.dataWriteOperations().nodeCreate();
        int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label);
        statement.dataWriteOperations().nodeAddLabel(node, labelId);
        return node;
    }

    private long createNode(Statement statement, String key, Object value) throws KernelException {
        long node = statement.dataWriteOperations().nodeCreate();
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)propertyKeyId, (Object)value));
        return node;
    }

    private long createLabeledNode(Statement statement, String label, String key, Object value) throws KernelException {
        long node = this.createLabeledNode(statement, label);
        int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)propertyKeyId, (Object)value));
        return node;
    }

    private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
        Statement statement = this.statementInNewTransaction((SecurityContext)AnonymousContext.writeToken());
        int label = statement.tokenWriteOperations().labelGetOrCreateForName(labelName);
        long node = statement.dataWriteOperations().nodeCreate();
        statement.dataWriteOperations().nodeAddLabel(node, label);
        int key = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(propertyKey);
        statement.dataWriteOperations().nodeSetProperty(node, Property.property((int)key, (Object)propertyValue));
        this.commit();
        this.createConstraint(labelName, propertyKey);
        return node;
    }

    private void createConstraint(String label, String propertyKey) throws KernelException {
        TokenWriteOperations tokenWriteOperations = this.tokenWriteOperationsInNewTransaction();
        int labelId = tokenWriteOperations.labelGetOrCreateForName(label);
        int propertyKeyId = tokenWriteOperations.propertyKeyGetOrCreateForName(propertyKey);
        this.commit();
        SchemaWriteOperations schemaWriteOperations = this.schemaWriteOperationsInNewTransaction();
        schemaWriteOperations.uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}));
        this.commit();
    }
}

