/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StoreStatement;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.test.mockito.answer.Neo4jMockitoAnswers;

public class LabelTransactionStateTest {
    private final int labelId1 = 10;
    private final int labelId2 = 12;
    private final long nodeId = 20L;
    private StoreReadLayer store;
    private TransactionState txState;
    private StateHandlingStatementOperations txContext;
    private KernelStatement state;
    private StoreStatement storeStatement;

    @Before
    public void before() throws Exception {
        this.store = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)this.store.indexesGetForLabel(Matchers.anyInt())).then(Neo4jMockitoAnswers.answerAsIteratorFrom(Collections.emptyList()));
        Mockito.when((Object)this.store.indexesGetAll()).then(Neo4jMockitoAnswers.answerAsIteratorFrom(Collections.emptyList()));
        this.txState = new TxState();
        this.state = StatementOperationsTestHelper.mockedState(this.txState);
        this.txContext = new StateHandlingStatementOperations(this.store, (AutoIndexing)Mockito.mock(InternalAutoIndexing.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
        this.storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)this.state.getStoreStatement()).thenReturn((Object)this.storeStatement);
    }

    @Test
    public void addOnlyLabelShouldBeVisibleInTx() throws Exception {
        this.commitNoLabels();
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void addAdditionalLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 12);
        this.assertLabels(10, 12);
    }

    @Test
    public void addAlreadyExistingLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void removeCommittedLabelShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10, 12);
        this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        this.assertLabels(12);
    }

    @Test
    public void removeAddedLabelInTxShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeAddLabel(this.state, 20L, 12);
        this.txContext.nodeRemoveLabel(this.state, 20L, 12);
        this.assertLabels(10);
    }

    @Test
    public void addRemovedLabelInTxShouldBeReflectedWithinTx() throws Exception {
        this.commitLabels(10);
        this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void addedLabelsShouldBeReflectedWhenGettingNodesForLabel() throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(0L, 1, 2), LabelTransactionStateTest.labels(1L, 2, 3), LabelTransactionStateTest.labels(2L, 1, 3));
        List<IndexDescriptor> indexes = Collections.singletonList(IndexDescriptorFactory.forLabel((int)2, (int[])new int[]{2}));
        Mockito.when((Object)this.store.indexesGetForLabel(2)).thenReturn(indexes.iterator());
        this.txContext.nodeAddLabel(this.state, 2L, 2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{0L, 1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)this.txContext.nodesGetForLabel(this.state, 2)));
    }

    @Test
    public void removedLabelsShouldBeReflectedWhenGettingNodesForLabel() throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(0L, 1, 2), LabelTransactionStateTest.labels(1L, 2, 3), LabelTransactionStateTest.labels(2L, 1, 3));
        this.txContext.nodeRemoveLabel(this.state, 1L, 2);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{0L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)this.txContext.nodesGetForLabel(this.state, 2)));
    }

    @Test
    public void addingNewLabelToNodeShouldRespondTrue() throws Exception {
        this.commitNoLabels();
        boolean added = this.txContext.nodeAddLabel(this.state, 20L, 10);
        Assert.assertTrue((String)"Should have been added now", (boolean)added);
    }

    @Test
    public void addingExistingLabelToNodeShouldRespondFalse() throws Exception {
        this.commitLabels(10);
        boolean added = this.txContext.nodeAddLabel(this.state, 20L, 10);
        Assert.assertFalse((String)"Shouldn't have been added now", (boolean)added);
    }

    @Test
    public void removingExistingLabelFromNodeShouldRespondTrue() throws Exception {
        this.commitLabels(10);
        boolean removed = this.txContext.nodeRemoveLabel(this.state, 20L, 10);
        Assert.assertTrue((String)"Should have been removed now", (boolean)removed);
    }

    @Test
    public void removingNonExistentLabelFromNodeShouldRespondFalse() throws Exception {
        this.commitNoLabels();
        this.txContext.nodeAddLabel(this.state, 20L, 10);
        this.assertLabels(10);
    }

    @Test
    public void should_return_true_when_adding_new_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L));
        Mockito.when((Object)this.store.nodeGetProperties((StorageStatement)Matchers.eq((Object)this.storeStatement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new DefinedProperty[0]));
        boolean added = this.txContext.nodeAddLabel(this.state, 1337L, 12);
        Assert.assertTrue((String)"Label should have been added", (boolean)added);
    }

    @Test
    public void should_return_false_when_adding_existing_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L, StubCursors.labels(12)));
        Mockito.when((Object)this.store.nodeGetProperties((StorageStatement)Matchers.eq((Object)this.storeStatement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new DefinedProperty[0]));
        boolean added = this.txContext.nodeAddLabel(this.state, 1337L, 12);
        Assert.assertFalse((String)"Label should have been added", (boolean)added);
    }

    @Test
    public void should_return_true_when_removing_existing_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L, StubCursors.labels(12)));
        Mockito.when((Object)this.store.nodeGetProperties((StorageStatement)Matchers.eq((Object)this.storeStatement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new DefinedProperty[0]));
        boolean added = this.txContext.nodeRemoveLabel(this.state, 1337L, 12);
        Assert.assertTrue((String)"Label should have been removed", (boolean)added);
    }

    @Test
    public void should_return_true_when_removing_non_existant_label() throws Exception {
        Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(1337L)).thenReturn(StubCursors.asNodeCursor(1337L));
        boolean removed = this.txContext.nodeRemoveLabel(this.state, 1337L, 12);
        Assert.assertFalse((String)"Label should have been removed", (boolean)removed);
    }

    private static Labels labels(long nodeId, int ... labelIds) {
        return new Labels(nodeId, labelIds);
    }

    private void commitLabels(Labels ... labels) throws Exception {
        HashMap<Integer, Collection> allLabels = new HashMap<Integer, Collection>();
        for (Labels nodeLabels : labels) {
            Mockito.when((Object)this.storeStatement.acquireSingleNodeCursor(nodeLabels.nodeId)).thenReturn(StubCursors.asNodeCursor(nodeLabels.nodeId, StubCursors.labels(nodeLabels.labelIds)));
            Mockito.when((Object)this.store.nodeGetProperties((StorageStatement)Matchers.eq((Object)this.storeStatement), (NodeItem)Matchers.any(NodeItem.class), (AssertOpen)Matchers.any(AssertOpen.class))).thenReturn(StubCursors.asPropertyCursor(new DefinedProperty[0]));
            for (int label : nodeLabels.labelIds) {
                Collection nodes = allLabels.computeIfAbsent(label, k -> new ArrayList());
                nodes.add(nodeLabels.nodeId);
            }
        }
        for (Map.Entry entry : allLabels.entrySet()) {
            Mockito.when((Object)this.store.nodesGetForLabel(this.state.getStoreStatement(), ((Integer)entry.getKey()).intValue())).then(Neo4jMockitoAnswers.answerAsPrimitiveLongIteratorFrom((Iterable)entry.getValue()));
        }
    }

    private void commitNoLabels() throws Exception {
        this.commitLabels(new int[0]);
    }

    private void commitLabels(int ... labels) throws Exception {
        this.commitLabels(LabelTransactionStateTest.labels(20L, labels));
    }

    private void assertLabels(int ... labels) throws EntityNotFoundException {
        this.txContext.nodeCursorById(this.state, 20L).forAll(node -> Assert.assertEquals((Object)PrimitiveIntCollections.asSet((int[])labels), (Object)node.labels()));
        this.txContext.nodeCursorById(this.state, 20L).forAll(node -> {
            for (int label : labels) {
                Assert.assertTrue((String)"Expected labels not found on node", (boolean)node.hasLabel(label));
            }
        });
    }

    private static class Labels {
        private final long nodeId;
        private final int[] labelIds;

        Labels(long nodeId, int ... labelIds) {
            this.nodeId = nodeId;
            this.labelIds = labelIds;
        }
    }
}

