/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.core.InMemoryTokenCache;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.storageengine.api.Token;

public class InMemoryTokenCacheTest {
    private static final String INBOUND2_TYPE = "inbound2";
    private static final String INBOUND1_TYPE = "inbound1";
    @Rule
    public ExpectedException expectedEcxeption = ExpectedException.none();

    @Test
    public void addTokenWithDuplicatedNotAllowed() {
        InMemoryTokenCache<RelationshipTypeToken> tokenCache = this.createTokenCache();
        tokenCache.put((Token)new RelationshipTypeToken(INBOUND1_TYPE, 1));
        tokenCache.put((Token)new RelationshipTypeToken(INBOUND2_TYPE, 2));
        this.expectedEcxeption.expect(NonUniqueTokenException.class);
        this.expectedEcxeption.expectMessage("The testType \"inbound1\" is not unique");
        tokenCache.put((Token)new RelationshipTypeToken(INBOUND1_TYPE, 3));
    }

    @Test
    public void keepOriginalTokenWhenAddDuplicate() {
        InMemoryTokenCache<RelationshipTypeToken> tokenCache = this.createTokenCache();
        tokenCache.put((Token)new RelationshipTypeToken(INBOUND1_TYPE, 1));
        tokenCache.put((Token)new RelationshipTypeToken(INBOUND2_TYPE, 2));
        this.tryToAddDuplicate(tokenCache);
        Assert.assertEquals((long)1L, (long)tokenCache.getId(INBOUND1_TYPE).intValue());
        Assert.assertEquals((long)2L, (long)tokenCache.getId(INBOUND2_TYPE).intValue());
        Assert.assertNull((Object)tokenCache.getToken(3));
    }

    private InMemoryTokenCache<RelationshipTypeToken> createTokenCache() {
        return new InMemoryTokenCache("testType");
    }

    private void tryToAddDuplicate(InMemoryTokenCache<RelationshipTypeToken> tokenCache) {
        try {
            tokenCache.put((Token)new RelationshipTypeToken(INBOUND1_TYPE, 3));
        }
        catch (NonUniqueTokenException nonUniqueTokenException) {
            // empty catch block
        }
    }
}

