/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestCrashWithRebuildSlow {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crashAndRebuildSlowWithDynamicStringDeletions() throws Exception {
        File storeDir = new File("dir").getAbsoluteFile();
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.record_id_batch_size, "1").newGraphDatabase();
        List<Long> deletedNodeIds = TestCrashWithRebuildSlow.produceNonCleanDefraggedStringStore((GraphDatabaseService)db);
        Map<IdType, Long> highIdsBeforeCrash = TestCrashWithRebuildSlow.getHighIds(db);
        long checksumBefore = ((EphemeralFileSystemAbstraction)this.fs.get()).checksum();
        long checksumBefore2 = ((EphemeralFileSystemAbstraction)this.fs.get()).checksum();
        Assert.assertThat((Object)checksumBefore, (Matcher)Matchers.equalTo((Object)checksumBefore2));
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(() -> db.shutdown());
        long snapshotChecksum = snapshot.checksum();
        if (snapshotChecksum != checksumBefore) {
            try (FileOutputStream out = new FileOutputStream(this.testDir.file("snapshot.zip"));){
                snapshot.dumpZip((OutputStream)out);
            }
            out = new FileOutputStream(this.testDir.file("fs.zip"));
            var13_10 = null;
            try {
                ((EphemeralFileSystemAbstraction)this.fs.get()).dumpZip((OutputStream)out);
            }
            catch (Throwable throwable) {
                var13_10 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var13_10 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable) {
                            var13_10.addSuppressed(throwable);
                        }
                    } else {
                        ((OutputStream)out).close();
                    }
                }
            }
        }
        Assert.assertThat((Object)snapshotChecksum, (Matcher)CoreMatchers.equalTo((Object)checksumBefore));
        TestCrashWithRebuildSlow.assertNumberOfFreeIdsEquals(storeDir, (FileSystemAbstraction)snapshot, 0L);
        GraphDatabaseAPI newDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)snapshot).newImpermanentDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.rebuild_idgenerators_fast, "false").newGraphDatabase();
        Map<IdType, Long> highIdsAfterCrash = TestCrashWithRebuildSlow.getHighIds(newDb);
        Assert.assertEquals(highIdsBeforeCrash, highIdsAfterCrash);
        try (Transaction tx = newDb.beginTx();){
            int nameCount = 0;
            int relCount = 0;
            for (Node node : newDb.getAllNodes()) {
                ++nameCount;
                Assert.assertThat((Object)node, Neo4jMatchers.inTx((GraphDatabaseService)newDb, Neo4jMatchers.hasProperty("name"), true));
                relCount = (int)((long)relCount + Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING)));
            }
            Assert.assertEquals((long)16L, (long)nameCount);
            Assert.assertEquals((long)12L, (long)relCount);
            ArrayList<Long> newIds = new ArrayList<Long>();
            newIds.add(newDb.createNode().getId());
            newIds.add(newDb.createNode().getId());
            newIds.add(newDb.createNode().getId());
            newIds.add(newDb.createNode().getId());
            Assert.assertThat(newIds, (Matcher)Matchers.is(deletedNodeIds));
            tx.success();
        }
        finally {
            newDb.shutdown();
            snapshot.close();
        }
    }

    private static List<Long> produceNonCleanDefraggedStringStore(GraphDatabaseService db) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try (Transaction tx = db.beginTx();){
            Node previous = null;
            for (int i = 0; i < 20; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)"a looooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooong string");
                nodes.add(node);
                if (previous != null) {
                    Relationship relationship = previous.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                }
                previous = node;
            }
            tx.success();
        }
        ArrayList<Long> deletedNodeIds = new ArrayList<Long>();
        try (Transaction tx = db.beginTx();){
            Node a = (Node)nodes.get(5);
            Node b = (Node)nodes.get(7);
            Node c = (Node)nodes.get(8);
            Node d = (Node)nodes.get(10);
            deletedNodeIds.add(a.getId());
            deletedNodeIds.add(b.getId());
            deletedNodeIds.add(c.getId());
            deletedNodeIds.add(d.getId());
            TestCrashWithRebuildSlow.delete(a);
            TestCrashWithRebuildSlow.delete(b);
            TestCrashWithRebuildSlow.delete(c);
            TestCrashWithRebuildSlow.delete(d);
            tx.success();
        }
        return deletedNodeIds;
    }

    private static void delete(Node node) {
        for (Relationship rel : node.getRelationships()) {
            rel.delete();
        }
        node.delete();
    }

    private static Map<IdType, Long> getHighIds(GraphDatabaseAPI db) {
        final HashMap<IdType, Long> highIds = new HashMap<IdType, Long>();
        NeoStores neoStores = ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        Visitor<CommonAbstractStore, RuntimeException> visitor = new Visitor<CommonAbstractStore, RuntimeException>(){

            public boolean visit(CommonAbstractStore store) throws RuntimeException {
                highIds.put(store.getIdType(), store.getHighId());
                return true;
            }
        };
        neoStores.visitStore((Visitor)visitor);
        return highIds;
    }

    private static void assertNumberOfFreeIdsEquals(File storeDir, FileSystemAbstraction fs, long numberOfFreeIds) {
        long fileSize = fs.getFileSize(new File(storeDir, "neostore.propertystore.db.strings.id"));
        long fileSizeWithoutHeader = fileSize - 9L;
        long actualFreeIds = fileSizeWithoutHeader / 8L;
        Assert.assertThat((String)"Id file should at least have a 9 byte header", (Object)fileSize, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(9L)));
        Assert.assertThat((String)"File should contain the expected number of free ids", (Object)actualFreeIds, (Matcher)Matchers.is((Object)numberOfFreeIds));
        Assert.assertThat((String)"File size should not contain more bytes than expected", (Object)(8L * numberOfFreeIds), (Matcher)Matchers.is((Object)fileSizeWithoutHeader));
    }
}

