/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.index.DummyIndexImplementation;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.kernel.spi.legacyindex.IndexProviders;

public class DummyIndexExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String IDENTIFIER = "test-dummy-neo-index";
    public static final String KEY_FAIL_ON_MUTATE = "fail_on_mutate";

    public DummyIndexExtensionFactory() {
        super(IDENTIFIER);
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        IndexProviders indexProviders = dependencies.getIndexProviders();
        return new Extension(indexProviders);
    }

    private static class Extension
    extends LifecycleAdapter {
        private final IndexProviders indexProviders;

        Extension(IndexProviders indexProviders) {
            this.indexProviders = indexProviders;
        }

        public void init() throws Throwable {
            this.indexProviders.registerIndexProvider(DummyIndexExtensionFactory.IDENTIFIER, (IndexImplementation)new DummyIndexImplementation());
        }

        public void shutdown() throws Throwable {
            this.indexProviders.unregisterIndexProvider(DummyIndexExtensionFactory.IDENTIFIER);
        }
    }

    public static interface Dependencies {
        public IndexProviders getIndexProviders();
    }
}

