/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;

public class NativeLabelScanStoreTest
extends LabelScanStoreTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    @Override
    protected LabelScanStore createLabelScanStore(FileSystemAbstraction fileSystemAbstraction, File rootFolder, FullStoreChangeStream fullStoreChangeStream, boolean usePersistentStore, boolean readOnly, LabelScanStore.Monitor monitor) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)monitor, new String[0]);
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
        return new NativeLabelScanStore(pageCache, rootFolder, fullStoreChangeStream, readOnly, monitors);
    }

    @Override
    protected Matcher<Iterable<? super String>> hasBareMinimumFileList() {
        return Matchers.hasItem((Matcher)Matchers.equalTo((Object)"neostore.labelscanstore.db"));
    }

    @Override
    protected void corruptIndex(FileSystemAbstraction fileSystem, File rootFolder) throws IOException {
        File lssFile = new File(rootFolder, "neostore.labelscanstore.db");
        this.scrambleFile(lssFile);
    }

    @Test
    public void shouldStartPopulationAgainIfNotCompletedFirstTime() throws Exception {
        LifeSupport life = new LifeSupport();
        LabelScanStoreTest.TrackingMonitor monitor = new LabelScanStoreTest.TrackingMonitor();
        life.add((Lifecycle)this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, false, (LabelScanStore.Monitor)monitor));
        life.init();
        Assert.assertTrue((boolean)monitor.noIndexCalled);
        monitor.reset();
        life.shutdown();
        life = new LifeSupport();
        life.add((Lifecycle)this.createLabelScanStore(this.fileSystemRule.get(), this.dir, FullStoreChangeStream.EMPTY, true, false, (LabelScanStore.Monitor)monitor));
        life.init();
        Assert.assertTrue((boolean)monitor.corruptedIndex);
        life.start();
        Assert.assertTrue((boolean)monitor.rebuildingCalled);
        Assert.assertTrue((boolean)monitor.rebuiltCalled);
        life.shutdown();
    }
}

