/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.locking.ResourceTypes;

public class IndexEntryResourceTypesTest {
    public static final int labelId = 1;
    public static final int propertyId = 2;
    public static final String value = "value";

    @Test
    public void shouldProduceBackwardsCompatibleId() {
        long id = ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)2, (Object)value)});
        MatcherAssert.assertThat((Object)id, (Matcher)Matchers.equalTo((Object)155667838465249649L));
    }

    @Test
    public void shouldDifferentiateBetweenIndexes() {
        IndexQuery.ExactPredicate pred1 = IndexQuery.exact((int)1, (Object)value);
        IndexQuery.ExactPredicate pred2 = IndexQuery.exact((int)1, (Object)"value2");
        IndexQuery.ExactPredicate pred3 = IndexQuery.exact((int)2, (Object)value);
        IndexQuery.ExactPredicate pred4 = IndexQuery.exact((int)2, (Object)"value2");
        List<Long> ids = Arrays.asList(ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred2}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred3}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred4}))), ResourceTypes.indexEntryResourceId((long)2L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2}))), ResourceTypes.indexEntryResourceId((long)1L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2, pred3}))), ResourceTypes.indexEntryResourceId((long)2L, (IndexQuery.ExactPredicate[])((IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{pred1, pred2, pred3, pred4}))));
        Set uniqueIds = Iterables.asSet(ids);
        MatcherAssert.assertThat((Object)ids.size(), (Matcher)Matchers.equalTo((Object)uniqueIds.size()));
    }

    @Test
    public void mustBeAbleToHashAllTypesWith220HashFunction() throws Exception {
        this.verifyCanHashAllTypes(ResourceTypes::indexEntryResourceId_2_2_0);
    }

    @Test
    public void mustBeAbleToHashAllTypesWith4xHashFunction() throws Exception {
        this.verifyCanHashAllTypes(ResourceTypes::indexEntryResourceId_4_x);
    }

    private void verifyCanHashAllTypes(IndexEntryHasher hasher) {
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)"")}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)"a")}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{""})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{"a"})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{"a", "b"})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)true)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[]{true})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[]{true, false})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean(true))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[]{true})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[]{true, false})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[]{(byte)1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[]{(byte)1, (byte)2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[]{(short)1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[]{(short)1, (short)2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[]{'a'})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[]{'a', 'b'})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character('a'))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a')})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[]{1.0f})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[]{1.0f, 2.0f})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float(1.0f))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f)})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[]{1L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[]{1L, 2L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long(1L))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[]{1L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[]{1L, 2L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1.0)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[]{1.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[]{1.0, 2.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double(1.0))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[]{1.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[]{1.0, 2.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)""), IndexQuery.exact((int)-2, (Object)"")}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)"a"), IndexQuery.exact((int)-2, (Object)"a")}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[0]), IndexQuery.exact((int)-2, (Object)new String[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{""}), IndexQuery.exact((int)-2, (Object)new String[]{""})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{"a"}), IndexQuery.exact((int)-2, (Object)new String[]{"a"})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new String[]{"a", "b"}), IndexQuery.exact((int)-2, (Object)new String[]{"a", "b"})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)true), IndexQuery.exact((int)-2, (Object)true)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[0]), IndexQuery.exact((int)-2, (Object)new boolean[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[]{true}), IndexQuery.exact((int)-2, (Object)new boolean[]{true})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new boolean[]{true, false}), IndexQuery.exact((int)-2, (Object)new boolean[]{true, false})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean(true)), IndexQuery.exact((int)-2, (Object)new Boolean(true))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[0]), IndexQuery.exact((int)-2, (Object)new Boolean[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[]{true}), IndexQuery.exact((int)-2, (Object)new Boolean[]{true})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Boolean[]{true, false}), IndexQuery.exact((int)-2, (Object)new Boolean[]{true, false})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1), IndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[0]), IndexQuery.exact((int)-2, (Object)new byte[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[]{1}), IndexQuery.exact((int)-2, (Object)new byte[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new byte[]{1, 2}), IndexQuery.exact((int)-2, (Object)new byte[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte(1)), IndexQuery.exact((int)-2, (Object)new Byte(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[0]), IndexQuery.exact((int)-2, (Object)new Byte[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[]{(byte)1}), IndexQuery.exact((int)-2, (Object)new Byte[]{(byte)1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Byte[]{(byte)1, (byte)2}), IndexQuery.exact((int)-2, (Object)new Byte[]{(byte)1, (byte)2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1), IndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[0]), IndexQuery.exact((int)-2, (Object)new short[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[]{1}), IndexQuery.exact((int)-2, (Object)new short[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new short[]{1, 2}), IndexQuery.exact((int)-2, (Object)new short[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short(1)), IndexQuery.exact((int)-2, (Object)new Short(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[0]), IndexQuery.exact((int)-2, (Object)new Short[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[]{(short)1}), IndexQuery.exact((int)-2, (Object)new Short[]{(short)1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Short[]{(short)1, (short)2}), IndexQuery.exact((int)-2, (Object)new Short[]{(short)1, (short)2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)Character.valueOf('a')), IndexQuery.exact((int)-2, (Object)Character.valueOf('a'))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[0]), IndexQuery.exact((int)-2, (Object)new char[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[]{'a'}), IndexQuery.exact((int)-2, (Object)new char[]{'a'})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new char[]{'a', 'b'}), IndexQuery.exact((int)-2, (Object)new char[]{'a', 'b'})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character('a')), IndexQuery.exact((int)-2, (Object)new Character('a'))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[0]), IndexQuery.exact((int)-2, (Object)new Character[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a')}), IndexQuery.exact((int)-2, (Object)new Character[]{Character.valueOf('a')})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')}), IndexQuery.exact((int)-2, (Object)new Character[]{Character.valueOf('a'), Character.valueOf('b')})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)Float.valueOf(1.0f)), IndexQuery.exact((int)-2, (Object)Float.valueOf(1.0f))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[0]), IndexQuery.exact((int)-2, (Object)new float[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[]{1.0f}), IndexQuery.exact((int)-2, (Object)new float[]{1.0f})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new float[]{1.0f, 2.0f}), IndexQuery.exact((int)-2, (Object)new float[]{1.0f, 2.0f})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float(1.0f)), IndexQuery.exact((int)-2, (Object)new Float(1.0f))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[0]), IndexQuery.exact((int)-2, (Object)new Float[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f)}), IndexQuery.exact((int)-2, (Object)new Float[]{Float.valueOf(1.0f)})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)}), IndexQuery.exact((int)-2, (Object)new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f)})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1), IndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[0]), IndexQuery.exact((int)-2, (Object)new int[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[]{1}), IndexQuery.exact((int)-2, (Object)new int[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new int[]{1, 2}), IndexQuery.exact((int)-2, (Object)new int[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer(1)), IndexQuery.exact((int)-2, (Object)new Integer(1))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[0]), IndexQuery.exact((int)-2, (Object)new Integer[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[]{1}), IndexQuery.exact((int)-2, (Object)new Integer[]{1})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Integer[]{1, 2}), IndexQuery.exact((int)-2, (Object)new Integer[]{1, 2})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1), IndexQuery.exact((int)-2, (Object)1)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[0]), IndexQuery.exact((int)-2, (Object)new long[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[]{1L}), IndexQuery.exact((int)-2, (Object)new long[]{1L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new long[]{1L, 2L}), IndexQuery.exact((int)-2, (Object)new long[]{1L, 2L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long(1L)), IndexQuery.exact((int)-2, (Object)new Long(1L))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[0]), IndexQuery.exact((int)-2, (Object)new Long[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[]{1L}), IndexQuery.exact((int)-2, (Object)new Long[]{1L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Long[]{1L, 2L}), IndexQuery.exact((int)-2, (Object)new Long[]{1L, 2L})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)1.0), IndexQuery.exact((int)-2, (Object)1.0)}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[0]), IndexQuery.exact((int)-2, (Object)new double[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[]{1.0}), IndexQuery.exact((int)-2, (Object)new double[]{1.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new double[]{1.0, 2.0}), IndexQuery.exact((int)-2, (Object)new double[]{1.0, 2.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double(1.0)), IndexQuery.exact((int)-2, (Object)new Double(1.0))}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[0]), IndexQuery.exact((int)-2, (Object)new Double[0])}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[]{1.0}), IndexQuery.exact((int)-2, (Object)new Double[]{1.0})}));
        hasher.hash(42L, (IndexQuery.ExactPredicate[])Iterators.array((Object[])new IndexQuery.ExactPredicate[]{IndexQuery.exact((int)1, (Object)new Double[]{1.0, 2.0}), IndexQuery.exact((int)-2, (Object)new Double[]{1.0, 2.0})}));
    }

    private static interface IndexEntryHasher {
        public long hash(long var1, IndexQuery.ExactPredicate[] var3);
    }
}

