/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.CallableUserAggregationFunction;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;

public class ResourceInjectionTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private ReflectiveProcedureCompiler compiler;
    private Log log = (Log)Mockito.mock(Log.class);

    public static String notAvailableMessage(String procName) {
        return (String)Matchers.argThat(ResourceInjectionTest.notAvailableMessageMatcher(procName));
    }

    private static Matcher<String> notAvailableMessageMatcher(String procName) {
        return org.hamcrest.Matchers.allOf((Matcher)CoreMatchers.containsString((String)procName), (Matcher)CoreMatchers.containsString((String)"unavailable"));
    }

    @Before
    public void setUp() {
        ComponentRegistry safeComponents = new ComponentRegistry();
        ComponentRegistry allComponents = new ComponentRegistry();
        safeComponents.register(MyAwesomeAPI.class, ctx -> new MyAwesomeAPI());
        allComponents.register(MyAwesomeAPI.class, ctx -> new MyAwesomeAPI());
        allComponents.register(MyUnsafeAPI.class, ctx -> new MyUnsafeAPI());
        this.compiler = new ReflectiveProcedureCompiler(new TypeMappers(), safeComponents, allComponents, this.log, ProcedureConfig.DEFAULT);
    }

    @Test
    public void shouldCompileAndRunProcedure() throws Throwable {
        CallableProcedure proc = (CallableProcedure)this.compiler.compileProcedure(ProcedureWithInjectedAPI.class, Optional.empty(), true).get(0);
        List out = Iterators.asList((RawIterator)proc.apply((Context)new BasicContext(), new Object[0]));
        Assert.assertThat(out.get(0), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Bonnie"}));
        Assert.assertThat(out.get(1), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Clyde"}));
    }

    @Test
    public void shouldFailNicelyWhenUnknownAPI() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to set up injection for procedure `ProcedureWithUnknownAPI`, the field `api` has type `class org.neo4j.kernel.impl.proc.ResourceInjectionTest$UnknownAPI` which is not a known injectable component.");
        this.compiler.compileProcedure(ProcedureWithUnknownAPI.class, Optional.empty(), true);
    }

    @Test
    public void shouldCompileAndRunUnsafeProcedureUnsafeMode() throws Throwable {
        CallableProcedure proc = (CallableProcedure)this.compiler.compileProcedure(ProcedureWithUnsafeAPI.class, Optional.empty(), true).get(0);
        List out = Iterators.asList((RawIterator)proc.apply((Context)new BasicContext(), new Object[0]));
        Assert.assertThat(out.get(0), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Morpheus"}));
        Assert.assertThat(out.get(1), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Trinity"}));
        Assert.assertThat(out.get(2), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Neo"}));
        Assert.assertThat(out.get(3), (Matcher)CoreMatchers.equalTo((Object)new Object[]{"Emil"}));
    }

    @Test
    public void shouldFailNicelyWhenUnsafeAPISafeMode() throws Throwable {
        List procList = this.compiler.compileProcedure(ProcedureWithUnsafeAPI.class, Optional.empty(), false);
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.listCoolPeople"));
        Assert.assertThat((Object)procList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        try {
            ((CallableProcedure)procList.get(0)).apply((Context)new BasicContext(), new Object[0]);
            Assert.fail();
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.getMessage(), ResourceInjectionTest.notAvailableMessageMatcher("org.neo4j.kernel.impl.proc.listCoolPeople"));
        }
    }

    @Test
    public void shouldCompileAndRunUserFunctions() throws Throwable {
        CallableUserFunction proc = (CallableUserFunction)this.compiler.compileFunction(FunctionWithInjectedAPI.class).get(0);
        Object out = proc.apply((Context)new BasicContext(), new Object[0]);
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.equalTo((Object)"[Bonnie, Clyde]"));
    }

    @Test
    public void shouldFailNicelyWhenFunctionUsesUnknownAPI() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to set up injection for procedure `FunctionWithUnknownAPI`, the field `api` has type `class org.neo4j.kernel.impl.proc.ResourceInjectionTest$UnknownAPI` which is not a known injectable component.");
        this.compiler.compileFunction(FunctionWithUnknownAPI.class);
    }

    @Test
    public void shouldFailNicelyWhenUnsafeAPISafeModeFunction() throws Throwable {
        List procList = this.compiler.compileFunction(FunctionWithUnsafeAPI.class);
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.listCoolPeople"));
        Assert.assertThat((Object)procList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        try {
            ((CallableUserFunction)procList.get(0)).apply((Context)new BasicContext(), new Object[0]);
            Assert.fail();
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.getMessage(), ResourceInjectionTest.notAvailableMessageMatcher("org.neo4j.kernel.impl.proc.listCoolPeople"));
        }
    }

    @Test
    public void shouldCompileAndRunUserAggregationFunctions() throws Throwable {
        CallableUserAggregationFunction proc = (CallableUserAggregationFunction)this.compiler.compileAggregationFunction(AggregationFunctionWithInjectedAPI.class).get(0);
        proc.create((Context)new BasicContext()).update(new Object[0]);
        Object out = proc.create((Context)new BasicContext()).result();
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.equalTo((Object)"[Bonnie, Clyde]"));
    }

    @Test
    public void shouldFailNicelyWhenAggregationFunctionUsesUnknownAPI() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Unable to set up injection for procedure `AggregationFunctionWithUnknownAPI`, the field `api` has type `class org.neo4j.kernel.impl.proc.ResourceInjectionTest$UnknownAPI` which is not a known injectable component.");
        this.compiler.compileAggregationFunction(AggregationFunctionWithUnknownAPI.class);
    }

    @Test
    public void shouldFailNicelyWhenUnsafeAPISafeModeAggregationFunction() throws Throwable {
        List procList = this.compiler.compileAggregationFunction(AggregationFunctionWithUnsafeAPI.class);
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.listCoolPeople"));
        Assert.assertThat((Object)procList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        try {
            ((CallableUserAggregationFunction)procList.get(0)).create((Context)new BasicContext()).update(new Object[0]);
            Object out = ((CallableUserAggregationFunction)procList.get(0)).create((Context)new BasicContext()).result();
            Assert.fail();
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.getMessage(), ResourceInjectionTest.notAvailableMessageMatcher("org.neo4j.kernel.impl.proc.listCoolPeople"));
        }
    }

    @Test
    public void shouldFailNicelyWhenAllUsesUnsafeAPI() throws Throwable {
        this.compiler.compileFunction(FunctionsAndProcedureUnsafe.class);
        this.compiler.compileProcedure(FunctionsAndProcedureUnsafe.class, Optional.empty(), false);
        this.compiler.compileAggregationFunction(FunctionsAndProcedureUnsafe.class);
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.safeUserFunctionInUnsafeAPIClass"));
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.listCoolPeopleProcedure"));
        ((Log)Mockito.verify((Object)this.log)).warn(ResourceInjectionTest.notAvailableMessage("org.neo4j.kernel.impl.proc.listCoolPeople "));
    }

    public static class FunctionsAndProcedureUnsafe {
        @org.neo4j.procedure.Context
        public MyUnsafeAPI api;

        @UserAggregationFunction
        public VoidOutput listCoolPeople() {
            return new VoidOutput(this.api);
        }

        @Procedure
        public Stream<MyOutputRecord> listCoolPeopleProcedure() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }

        @UserFunction
        public String safeUserFunctionInUnsafeAPIClass() {
            return "a safe function";
        }

        public static class VoidOutput {
            private MyUnsafeAPI api;

            public VoidOutput(MyUnsafeAPI api) {
                this.api = api;
            }

            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return this.api.listCoolPeople().toString();
            }
        }
    }

    public static class AggregationFunctionWithUnsafeAPI {
        @org.neo4j.procedure.Context
        public MyUnsafeAPI api;

        @UserAggregationFunction
        public VoidOutput listCoolPeople() {
            return new VoidOutput(this.api);
        }

        public static class VoidOutput {
            private MyUnsafeAPI api;

            public VoidOutput(MyUnsafeAPI api) {
                this.api = api;
            }

            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return this.api.listCoolPeople().toString();
            }
        }
    }

    public static class FunctionWithUnsafeAPI {
        @org.neo4j.procedure.Context
        public MyUnsafeAPI api;

        @UserFunction
        public String listCoolPeople() {
            return this.api.listCoolPeople().toString();
        }
    }

    public static class ProcedureWithUnsafeAPI {
        @org.neo4j.procedure.Context
        public MyUnsafeAPI api;

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }
    }

    public static class AggregationFunctionWithUnknownAPI {
        @org.neo4j.procedure.Context
        public UnknownAPI api;

        @UserAggregationFunction
        public VoidOutput listCoolPeople() {
            return new VoidOutput(this.api);
        }

        public static class VoidOutput {
            private UnknownAPI api;

            public VoidOutput(UnknownAPI api) {
                this.api = api;
            }

            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return this.api.listCoolPeople().toString();
            }
        }
    }

    public static class FunctionWithUnknownAPI {
        @org.neo4j.procedure.Context
        public UnknownAPI api;

        @UserFunction
        public String listCoolPeople() {
            return this.api.listCoolPeople().toString();
        }
    }

    public static class ProcedureWithUnknownAPI {
        @org.neo4j.procedure.Context
        public UnknownAPI api;

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }
    }

    public static class AggregationFunctionWithInjectedAPI {
        @org.neo4j.procedure.Context
        public MyAwesomeAPI api;

        @UserAggregationFunction
        public VoidOutput listCoolPeople() {
            return new VoidOutput(this.api);
        }

        public static class VoidOutput {
            private MyAwesomeAPI api;

            public VoidOutput(MyAwesomeAPI api) {
                this.api = api;
            }

            @UserAggregationUpdate
            public void update() {
            }

            @UserAggregationResult
            public String result() {
                return this.api.listCoolPeople().toString();
            }
        }
    }

    public static class FunctionWithInjectedAPI {
        @org.neo4j.procedure.Context
        public MyAwesomeAPI api;

        @UserFunction
        public String listCoolPeople() {
            return this.api.listCoolPeople().toString();
        }
    }

    public static class ProcedureWithInjectedAPI {
        @org.neo4j.procedure.Context
        public MyAwesomeAPI api;

        @Procedure
        public Stream<MyOutputRecord> listCoolPeople() {
            return this.api.listCoolPeople().stream().map(MyOutputRecord::new);
        }
    }

    public static class MyUnsafeAPI {
        List<String> listCoolPeople() {
            return Arrays.asList("Morpheus", "Trinity", "Neo", "Emil");
        }
    }

    public static class UnknownAPI {
        List<String> listCoolPeople() {
            return Collections.singletonList("booh!");
        }
    }

    public static class MyAwesomeAPI {
        List<String> listCoolPeople() {
            return Arrays.asList("Bonnie", "Clyde");
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

