/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.query.clientconnection.BoltConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.HttpConnectionInfo;
import org.neo4j.kernel.impl.query.clientconnection.ShellConnectionInfo;

public class ClientConnectionInfoTest {
    @Test
    public void connectionDetailsForBoltQuerySource() throws Exception {
        ClientConnectionInfo clientConnection = new BoltConnectionInfo("username", "neo4j-java-bolt-driver", (SocketAddress)new InetSocketAddress("127.0.0.1", 56789), (SocketAddress)new InetSocketAddress("127.0.0.1", 7687)).withUsername("username");
        String connectionDetails = clientConnection.asConnectionDetails();
        Assert.assertEquals((Object)"bolt-session\tbolt\tusername\tneo4j-java-bolt-driver\t\tclient/127.0.0.1:56789\tserver/127.0.0.1:7687>\tusername", (Object)connectionDetails);
    }

    @Test
    public void connectionDetailsForHttpQuerySource() throws Exception {
        ClientConnectionInfo clientConnection = new HttpConnectionInfo("http", null, new InetSocketAddress("127.0.0.1", 1337), null, "/db/data/transaction/45/commit").withUsername("username");
        String connectionDetails = clientConnection.asConnectionDetails();
        Assert.assertEquals((Object)"server-session\thttp\t127.0.0.1\t/db/data/transaction/45/commit\tusername", (Object)connectionDetails);
    }

    @Test
    public void connectionDetailsForEmbeddedQuerySource() throws Exception {
        String connectionDetails = ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails();
        Assert.assertEquals((Object)"embedded-session\t", (Object)connectionDetails);
    }

    @Test
    public void connectionDetailsForShellSession() throws Exception {
        ClientConnectionInfo clientConnection = new ShellConnectionInfo((Serializable)Integer.valueOf(1)).withUsername("FULL");
        String connectionDetails = clientConnection.asConnectionDetails();
        Assert.assertEquals((Object)"shell-session\tshell\t1\tFULL", (Object)connectionDetails);
    }
}

