/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.store.StoreFailureException;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.NodeRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.PropertyKeyTokenRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.PropertyRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.RelationshipRecordFormat;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IdGeneratorTest {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fs;
    private File storeDir;

    @Before
    public void doBefore() {
        this.fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
        this.storeDir = AbstractNeo4jTestCase.getStorePath("xatest");
        this.fs.mkdirs(this.storeDir);
    }

    private void deleteIdGeneratorFile() {
        this.fs.deleteFile(this.idGeneratorFile());
    }

    private File file(String name) {
        return new File(this.storeDir, name);
    }

    private File idGeneratorFile() {
        return this.file("testIdGenerator.id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotCreateIdGeneratorWithNullFileSystem() throws Exception {
        IdGeneratorImpl.createGenerator(null, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotCreateIdGeneratorWithNullFile() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, null, (long)0L, (boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void grabSizeCannotBeZero() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 0, 100L, false, () -> 0L).close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void grabSizeCannotBeNegative() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), -1, 100L, false, () -> 0L).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void createIdGeneratorMustRefuseOverwritingExistingFile() throws IOException {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1008, 1000L, false, () -> 0L);
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)true);
        }
        finally {
            this.closeIdGenerator((IdGenerator)idGenerator);
            StoreChannel fileChannel = this.fs.open(this.idGeneratorFile(), "rw");
            ByteBuffer buffer = ByteBuffer.allocate(9);
            Assert.assertEquals((long)9L, (long)fileChannel.read(buffer));
            buffer.flip();
            Assert.assertEquals((long)0L, (long)buffer.get());
            Assert.assertEquals((long)0L, (long)buffer.getLong());
            buffer.flip();
            int readCount = fileChannel.read(buffer);
            if (readCount != -1 && readCount != 0) {
                Assert.fail((String)("Id generator header not ok read 9 + " + readCount + " bytes from file"));
            }
            fileChannel.close();
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    private void closeIdGenerator(IdGenerator idGenerator) {
        idGenerator.close();
    }

    @Test
    public void mustOverwriteExistingFileIfRequested() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1008, 1000L, false, () -> 0L);
        long[] firstFirstIds = new long[]{idGenerator.nextId(), idGenerator.nextId(), idGenerator.nextId()};
        idGenerator.close();
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1008, 1000L, false, () -> 0L);
        long[] secondFirstIds = new long[]{idGenerator.nextId(), idGenerator.nextId(), idGenerator.nextId()};
        idGenerator.close();
        Assert.assertThat((Object)secondFirstIds, (Matcher)Matchers.is((Object)firstFirstIds));
    }

    @Test
    public void testStickyGenerator() {
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            IdGeneratorImpl idGen = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 3, 1000L, false, () -> 0L);
            try {
                new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 3, 1000L, false, () -> 0L);
                Assert.fail((String)"Opening sticky id generator should throw exception");
            }
            catch (StoreFailureException storeFailureException) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGen);
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNextId() {
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 3, 1000L, false, () -> 0L);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            idGenerator.freeId(1L);
            idGenerator.freeId(3L);
            idGenerator.freeId(5L);
            Assert.assertEquals((long)7L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 5, 1000L, false, () -> 0L);
            idGenerator.freeId(2L);
            idGenerator.freeId(4L);
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            idGenerator.freeId(1L);
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            idGenerator.freeId(3L);
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            idGenerator.freeId(5L);
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            idGenerator.freeId(8L);
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            idGenerator.freeId(9L);
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 3, 1000L, false, () -> 0L);
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)8L, (long)idGenerator.nextId());
            Assert.assertEquals((long)9L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            Assert.assertEquals((long)10L, (long)idGenerator.nextId());
            Assert.assertEquals((long)11L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFreeId() {
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 3, 1000L, false, () -> 0L);
            for (long i = 0L; i < 7L; ++i) {
                Assert.assertEquals((long)i, (long)idGenerator.nextId());
            }
            try {
                idGenerator.freeId(-1L);
                Assert.fail((String)"Negative id should throw exception");
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
            try {
                idGenerator.freeId(7L);
                Assert.fail((String)"Greater id than ever returned should throw exception");
            }
            catch (IllegalArgumentException i) {
                // empty catch block
            }
            for (int i = 0; i < 7; ++i) {
                idGenerator.freeId((long)i);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 2, 1000L, false, () -> 0L);
            Assert.assertEquals((long)5L, (long)idGenerator.nextId());
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
            Assert.assertEquals((long)3L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 30, 1000L, false, () -> 0L);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            Assert.assertEquals((long)4L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    @Test
    public void testClose() {
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 2, 1000L, false, () -> 0L);
            this.closeIdGenerator((IdGenerator)idGenerator);
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 2, 1000L, false, () -> 0L);
            Assert.assertEquals((long)0L, (long)idGenerator.nextId());
            Assert.assertEquals((long)1L, (long)idGenerator.nextId());
            Assert.assertEquals((long)2L, (long)idGenerator.nextId());
            this.closeIdGenerator((IdGenerator)idGenerator);
            try {
                idGenerator.nextId();
                Assert.fail((String)"nextId after close should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                idGenerator.freeId(0L);
                Assert.fail((String)"freeId after close should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOddAndEvenWorstCase() {
        File file;
        long i;
        IdGeneratorImpl idGenerator;
        int capacity = 8193;
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 128, (long)(capacity * 2), false, () -> 0L);
            for (int i2 = 0; i2 < capacity; ++i2) {
                idGenerator.nextId();
            }
            HashMap<Long, IdGeneratorTest> freedIds = new HashMap<Long, IdGeneratorTest>();
            for (i = 1L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 2000, (long)(capacity * 2), false, () -> 0L);
            long oldId = -1L;
            for (int i3 = 0; i3 < capacity - 1; i3 += 2) {
                long id = idGenerator.nextId();
                if (freedIds.remove(id) == null) {
                    throw new RuntimeException("Id=" + id + " prevId=" + oldId + " list.size()=" + freedIds.size());
                }
                oldId = id;
            }
            Assert.assertTrue((freedIds.values().size() == 0 ? 1 : 0) != 0);
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            file = this.idGeneratorFile();
            if (this.fs.fileExists(file)) {
                Assert.assertTrue((boolean)this.fs.deleteFile(file));
            }
        }
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 128, (long)(capacity * 2), false, () -> 0L);
            for (int i4 = 0; i4 < capacity; ++i4) {
                idGenerator.nextId();
            }
            HashMap<Long, IdGeneratorTest> freedIds = new HashMap<Long, IdGeneratorTest>();
            for (i = 0L; i < (long)capacity; i += 2L) {
                idGenerator.freeId(i);
                freedIds.put(i, this);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 2000, (long)(capacity * 2), false, () -> 0L);
            for (int i5 = 0; i5 < capacity; i5 += 2) {
                Assert.assertEquals((Object)this, freedIds.remove(idGenerator.nextId()));
            }
            Assert.assertEquals((long)0L, (long)freedIds.values().size());
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        Random random = new Random(System.currentTimeMillis());
        int capacity = random.nextInt(1024) + 1024;
        int grabSize = random.nextInt(128) + 128;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), grabSize, (long)(capacity * 2), false, () -> 0L);
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        float releaseIndex = 0.25f;
        float closeIndex = 0.05f;
        int currentIdCount = 0;
        try {
            while (currentIdCount < capacity) {
                float rIndex = random.nextFloat();
                if (rIndex < releaseIndex && currentIdCount > 0) {
                    idGenerator.freeId((long)((Long)idsTaken.remove(random.nextInt(currentIdCount))).intValue());
                    --currentIdCount;
                } else {
                    idsTaken.add(idGenerator.nextId());
                    ++currentIdCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                this.closeIdGenerator((IdGenerator)idGenerator);
                grabSize = random.nextInt(128) + 128;
                idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), grabSize, (long)(capacity * 2), false, () -> 0L);
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsignedId() {
        try {
            PropertyKeyTokenRecordFormat recordFormat = new PropertyKeyTokenRecordFormat();
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, recordFormat.getMaxId(), false, () -> 0L);
            idGenerator.setHighId(recordFormat.getMaxId());
            long id = idGenerator.nextId();
            Assert.assertEquals((long)recordFormat.getMaxId(), (long)id);
            idGenerator.freeId(id);
            try {
                idGenerator.nextId();
                Assert.fail((String)"Shouldn't be able to get next ID");
            }
            catch (StoreFailureException storeFailureException) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, recordFormat.getMaxId(), false, () -> 0L);
            Assert.assertEquals((long)(recordFormat.getMaxId() + 1L), (long)idGenerator.getHighId());
            id = idGenerator.nextId();
            Assert.assertEquals((long)recordFormat.getMaxId(), (long)id);
            try {
                idGenerator.nextId();
            }
            catch (StoreFailureException storeFailureException) {
                // empty catch block
            }
            this.closeIdGenerator((IdGenerator)idGenerator);
        }
        finally {
            File file = this.idGeneratorFile();
            if (file.exists()) {
                Assert.assertTrue((boolean)file.delete());
            }
        }
    }

    @Test
    public void makeSureIdCapacityCannotBeExceeded() throws Exception {
        RecordFormats formats = Standard.LATEST_RECORD_FORMATS;
        List<RecordFormat> recordFormats = Arrays.asList(formats.node(), formats.dynamic(), formats.labelToken(), formats.property(), formats.propertyKeyToken(), formats.relationship(), formats.relationshipGroup(), formats.relationshipTypeToken());
        for (RecordFormat format : recordFormats) {
            this.makeSureIdCapacityCannotBeExceeded(format);
        }
    }

    private void makeSureIdCapacityCannotBeExceeded(RecordFormat format) {
        this.deleteIdGeneratorFile();
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        long maxValue = format.getMaxId();
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, maxValue - 1L, false, () -> 0L);
        long id = maxValue - 2L;
        idGenerator.setHighId(id);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 1L), (long)idGenerator.nextId());
        try {
            idGenerator.nextId();
            Assert.fail((String)("Id capacity shouldn't be able to be exceeded for " + format));
        }
        catch (StoreFailureException storeFailureException) {
            // empty catch block
        }
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void makeSureMagicMinusOneIsNotReturnedFromNodeIdGenerator() throws Exception {
        this.makeSureMagicMinusOneIsSkipped((RecordFormat)new NodeRecordFormat());
        this.makeSureMagicMinusOneIsSkipped((RecordFormat)new RelationshipRecordFormat());
        this.makeSureMagicMinusOneIsSkipped((RecordFormat)new PropertyRecordFormat());
    }

    private void makeSureMagicMinusOneIsSkipped(RecordFormat format) {
        this.deleteIdGeneratorFile();
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, format.getMaxId(), false, () -> 0L);
        long id = (long)Math.pow(2.0, 32.0) - 3L;
        idGenerator.setHighId(id);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 1L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 3L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 4L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(id + 5L), (long)idGenerator.nextId());
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void makeSureMagicMinusOneCannotBeReturnedEvenIfFreed() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, new NodeRecordFormat().getMaxId(), false, () -> 0L);
        long magicMinusOne = (long)Math.pow(2.0, 32.0) - 1L;
        idGenerator.setHighId(magicMinusOne);
        Assert.assertEquals((long)(magicMinusOne + 1L), (long)idGenerator.nextId());
        idGenerator.freeId(magicMinusOne - 1L);
        idGenerator.freeId(magicMinusOne);
        this.closeIdGenerator((IdGenerator)idGenerator);
        idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 1, new NodeRecordFormat().getMaxId(), false, () -> 0L);
        Assert.assertEquals((long)(magicMinusOne - 1L), (long)idGenerator.nextId());
        Assert.assertEquals((long)(magicMinusOne + 2L), (long)idGenerator.nextId());
        this.closeIdGenerator((IdGenerator)idGenerator);
    }

    @Test
    public void commandsGetWrittenOnceSoThatFreedIdsGetsAddedOnlyOnce() throws Exception {
        Relationship relationship;
        Node otherNode;
        int i;
        File storeDir = new File("target/var/free-id-once");
        FileUtils.deleteRecursively((File)storeDir);
        GraphDatabaseService db = this.createTestDatabase(storeDir);
        RelationshipType type = RelationshipType.withName((String)"SOME_TYPE");
        HashSet<Long> createdNodeIds = new HashSet<Long>();
        HashSet<Long> createdRelationshipIds = new HashSet<Long>();
        Transaction tx = db.beginTx();
        Node commonNode = db.createNode();
        for (i = 0; i < 20; ++i) {
            otherNode = db.createNode();
            relationship = commonNode.createRelationshipTo(otherNode, type);
            if (i % 5 == 0) {
                otherNode.delete();
                relationship.delete();
                continue;
            }
            createdNodeIds.add(otherNode.getId());
            createdRelationshipIds.add(relationship.getId());
        }
        tx.success();
        tx.close();
        db.shutdown();
        db = this.createTestDatabase(storeDir);
        tx = db.beginTx();
        commonNode = db.getNodeById(commonNode.getId());
        for (i = 0; i < 100; ++i) {
            otherNode = db.createNode();
            if (!createdNodeIds.add(otherNode.getId())) {
                Assert.fail((String)"Managed to create a node with an id that was already in use");
            }
            if (createdRelationshipIds.add((relationship = commonNode.createRelationshipTo(otherNode, type)).getId())) continue;
            Assert.fail((String)"Managed to create a relationship with an id that was already in use");
        }
        tx.success();
        tx.close();
        tx = db.beginTx();
        for (Node node : db.getAllNodes()) {
            Iterables.lastOrNull((Iterable)node.getRelationships());
        }
        tx.close();
        db.shutdown();
    }

    @Test
    public void delete() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 10, 1000L, false, () -> 0L);
        long id = idGenerator.nextId();
        idGenerator.nextId();
        idGenerator.freeId(id);
        idGenerator.close();
        idGenerator.delete();
        Assert.assertFalse((boolean)this.idGeneratorFile().exists());
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
        idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 10, 1000L, false, () -> 0L);
        Assert.assertEquals((long)id, (long)idGenerator.nextId());
        idGenerator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testChurnIdBatchAtGrabSize() {
        File file;
        IdGeneratorImpl idGenerator = null;
        try {
            IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)this.idGeneratorFile(), (long)0L, (boolean)false);
            int grabSize = 10;
            int rounds = 10;
            idGenerator = new IdGeneratorImpl((FileSystemAbstraction)this.fs, this.idGeneratorFile(), 10, 1000L, true, () -> 0L);
            for (int i = 0; i < 10; ++i) {
                HashSet<Long> ids = new HashSet<Long>();
                for (int j = 0; j < 10; ++j) {
                    ids.add(idGenerator.nextId());
                }
                for (Long id : ids) {
                    idGenerator.freeId(id.longValue());
                }
            }
            long newId = idGenerator.nextId();
            Assert.assertTrue((String)("Expected IDs to be reused (10 at a time). high ID was: " + newId), (newId < 100L ? 1 : 0) != 0);
            if (idGenerator != null) {
                this.closeIdGenerator((IdGenerator)idGenerator);
            }
            if (!(file = this.idGeneratorFile()).exists()) return;
        }
        catch (Throwable throwable) {
            File file2;
            if (idGenerator != null) {
                this.closeIdGenerator((IdGenerator)idGenerator);
            }
            if (!(file2 = this.idGeneratorFile()).exists()) throw throwable;
            Assert.assertTrue((boolean)file2.delete());
            throw throwable;
        }
        Assert.assertTrue((boolean)file.delete());
    }

    private GraphDatabaseService createTestDatabase(File storeDir) {
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).newImpermanentDatabase(storeDir);
    }
}

