/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class IdContainerTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private FileSystemAbstraction fs;
    private File file;

    @Before
    public void setUp() throws Exception {
        this.fs = this.fileSystemRule.get();
        this.file = this.testDirectory.file("ids");
    }

    @Test
    public void shouldDeleteIfOpen() throws Exception {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.delete();
        Assert.assertFalse((boolean)this.fs.fileExists(this.file));
        idContainer.close(0L);
    }

    @Test
    public void shouldDeleteIfClosed() throws Exception {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.close(0L);
        idContainer.delete();
        Assert.assertFalse((boolean)this.fs.fileExists(this.file));
    }

    @Test
    public void shouldForceStickyMark() throws Exception {
        this.createEmptyFile();
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        try {
            IdContainer.readHighId((FileSystemAbstraction)this.fs, (File)this.file);
            Assert.fail((String)"Should have thrown, saying something with sticky generator");
        }
        catch (InvalidIdGeneratorException invalidIdGeneratorException) {
        }
        finally {
            idContainer.close(0L);
        }
    }

    @Test
    public void shouldTruncateTheFileIfOverwriting() throws Exception {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)30L, (boolean)false);
        IdContainer idContainer = new IdContainer(this.fs, this.file, 5, false);
        idContainer.init();
        for (int i = 0; i < 17; ++i) {
            idContainer.freeId((long)i);
        }
        idContainer.close(30L);
        Assert.assertThat((Object)((int)this.fs.getFileSize(this.file)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(9)));
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)30L, (boolean)false);
        Assert.assertEquals((long)9L, (long)((int)this.fs.getFileSize(this.file)));
        Assert.assertEquals((long)30L, (long)IdContainer.readHighId((FileSystemAbstraction)this.fs, (File)this.file));
        idContainer = new IdContainer(this.fs, this.file, 5, false);
        idContainer.init();
        Assert.assertEquals((long)30L, (long)idContainer.getInitialHighId());
        idContainer.close(30L);
    }

    @Test
    public void shouldReturnFalseOnInitIfTheFileWasCreated() throws Exception {
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        Assert.assertFalse((boolean)idContainer.init());
    }

    @Test
    public void shouldReturnTrueOnInitIfAProperFileWasThere() throws Exception {
        IdContainer idContainer = new IdContainer(this.fs, this.file, 100, false);
        idContainer.init();
        idContainer.close(100L);
        idContainer = new IdContainer(this.fs, this.file, 100, false);
        Assert.assertTrue((boolean)idContainer.init());
    }

    private void createEmptyFile() {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fs, (File)this.file, (long)42L, (boolean)false);
    }
}

