/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.validation.IdCapacityExceededException;
import org.neo4j.kernel.impl.store.id.validation.NegativeIdException;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class IdGeneratorImplTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final File file = new File("ids");

    @Test
    public void shouldNotAcceptMinusOne() throws Exception {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, () -> 0L);
        try {
            idGenerator.setHighId(-1L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NegativeIdException.class));
        }
    }

    @Test
    public void throwsWhenNextIdIsTooHigh() {
        long maxId = 10L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, maxId, false, () -> 0L);
        for (long i = 0L; i <= maxId; ++i) {
            idGenerator.nextId();
        }
        try {
            idGenerator.nextId();
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void throwsWhenGivenHighIdIsTooHigh() {
        long maxId = 10L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, maxId, false, () -> 0L);
        try {
            idGenerator.setHighId(maxId + 1L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IdCapacityExceededException.class));
        }
    }

    @Test
    public void highIdCouldBeSetToReservedId() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)0L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 1, Long.MAX_VALUE, false, () -> 0L);
        idGenerator.setHighId(0xFFFFFFFFL);
        Assert.assertEquals((long)0x100000000L, (long)idGenerator.nextId());
    }

    @Test
    public void correctDefragCountWhenHaveIdsInFile() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)100L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, true, () -> 100L);
        idGenerator.freeId(5L);
        idGenerator.close();
        IdGeneratorImpl reloadedIdGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, true, () -> 100L);
        Assert.assertEquals((long)1L, (long)reloadedIdGenerator.getDefragCount());
        Assert.assertEquals((long)5L, (long)reloadedIdGenerator.nextId());
        Assert.assertEquals((long)0L, (long)reloadedIdGenerator.getDefragCount());
    }

    @Test
    public void shouldReadHighIdUsingStaticMethod() throws Exception {
        long highId = 12345L;
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)highId, (boolean)false);
        long readHighId = IdGeneratorImpl.readHighId((FileSystemAbstraction)this.fsr.get(), (File)this.file);
        Assert.assertEquals((long)highId, (long)readHighId);
    }

    @Test
    public void shouldBeAbleToReadWrittenGenerator() {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)42L, (boolean)false);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, () -> 42L);
        idGenerator.close();
        idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, () -> 0L);
        Assert.assertThat((Object)idGenerator.getHighId(), (Matcher)Matchers.equalTo((Object)42L));
    }

    @Test
    public void constructorShouldCallHighIdSupplierOnNonExistingIdFile() throws Exception {
        Supplier highId = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(highId.get()).thenReturn((Object)0L);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, highId);
        ((Supplier)Mockito.verify((Object)highId)).get();
        idGenerator.close();
    }

    @Test
    public void constructorShouldNotCallHighIdSupplierOnCleanIdFile() throws Exception {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)this.fsr.get(), (File)this.file, (long)42L, (boolean)true);
        Supplier highId = (Supplier)Mockito.mock(Supplier.class);
        IdGeneratorImpl idGenerator = new IdGeneratorImpl(this.fsr.get(), this.file, 100, 100L, false, highId);
        idGenerator.close();
        Mockito.verifyZeroInteractions((Object[])new Object[]{highId});
    }
}

