/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ReuseExcessBatchIdsOnRestartIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void shouldReuseExcessBatchIdsWhichWerentUsedBeforeClose() throws Exception {
        Node secondNode;
        Node firstNode;
        try (Transaction tx = this.db.beginTx();){
            firstNode = this.db.createNode();
            tx.success();
        }
        this.db.restartDatabase(new String[0]);
        try (Transaction tx = this.db.beginTx();){
            secondNode = this.db.createNode();
            tx.success();
        }
        Assert.assertEquals((long)(firstNode.getId() + 1L), (long)secondNode.getId());
    }

    @Test(timeout=30000L)
    public void shouldBeAbleToReuseAllIdsInConcurrentCommitsWithRestart() throws Exception {
        int threads = Runtime.getRuntime().availableProcessors();
        int batchSize = Integer.parseInt(GraphDatabaseSettings.record_id_batch_size.getDefaultValue());
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        boolean[] createdIds = new boolean[threads * batchSize];
        for (int i = 0; i < threads; ++i) {
            executor.submit(() -> {
                try (Transaction tx = this.db.beginTx();){
                    for (int j = 0; j < batchSize / 2; ++j) {
                        int index = Math.toIntExact(this.db.createNode().getId());
                        createdIds[index] = true;
                    }
                    tx.success();
                }
            });
        }
        executor.shutdown();
        while (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
        Assert.assertFalse((boolean)ReuseExcessBatchIdsOnRestartIT.allTrue(createdIds));
        this.db.restartDatabase(new String[0]);
        try (Transaction tx = this.db.beginTx();){
            while (!ReuseExcessBatchIdsOnRestartIT.allTrue(createdIds)) {
                int index = Math.toIntExact(this.db.createNode().getId());
                assert (!createdIds[index]);
                createdIds[index] = true;
            }
            tx.success();
        }
    }

    private static boolean allTrue(boolean[] values) {
        for (boolean value : values) {
            if (value) continue;
            return false;
        }
        return true;
    }
}

