/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

public class KeyValueStoreFileTest {
    @Test
    public void shouldFindPageInPageCatalogue() throws Exception {
        Assert.assertEquals((String)"(single page) in middle of range", (long)0L, (long)CataloguePage.findPage(50, CataloguePage.page(1, 100)));
        Assert.assertEquals((String)"(single page) at beginning of range", (long)0L, (long)CataloguePage.findPage(1, CataloguePage.page(1, 100)));
        Assert.assertEquals((String)"(single page) at end of range", (long)0L, (long)CataloguePage.findPage(100, CataloguePage.page(1, 100)));
        Assert.assertEquals((String)"(single page) before range", (long)0L, (long)CataloguePage.findPage(1, CataloguePage.page(10, 100)));
        Assert.assertEquals((String)"(single page) after range", (long)1L, (long)CataloguePage.findPage(200, CataloguePage.page(1, 100)));
        Assert.assertEquals((String)"(two pages) at beginning of second page", (long)1L, (long)CataloguePage.findPage(11, CataloguePage.page(1, 10), CataloguePage.page(11, 20)));
        Assert.assertEquals((String)"(two pages) at end of first page", (long)0L, (long)CataloguePage.findPage(10, CataloguePage.page(1, 10), CataloguePage.page(11, 20)));
        Assert.assertEquals((String)"(two pages) between pages (-> second page)", (long)1L, (long)CataloguePage.findPage(11, CataloguePage.page(1, 10), CataloguePage.page(21, 30)));
        Assert.assertEquals((String)"(two pages) between pages (-> second page)", (long)1L, (long)CataloguePage.findPage(11, CataloguePage.page(1, 10), CataloguePage.page(12, 30)));
        Assert.assertEquals((String)"(two pages) after pages", (long)2L, (long)CataloguePage.findPage(31, CataloguePage.page(1, 10), CataloguePage.page(21, 30)));
        Assert.assertEquals((String)"(three pages) after pages", (long)3L, (long)CataloguePage.findPage(100, CataloguePage.page(1, 10), CataloguePage.page(21, 30), CataloguePage.page(41, 50)));
        Assert.assertEquals((String)"overlapping page boundary", (long)0L, (long)CataloguePage.findPage(17, CataloguePage.page(2, 17), CataloguePage.page(17, 32), CataloguePage.page(32, 50)));
        Assert.assertEquals((String)"multiple pages with same key", (long)1L, (long)CataloguePage.findPage(3, CataloguePage.page(1, 2), CataloguePage.page(2, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 3), CataloguePage.page(3, 4), CataloguePage.page(5, 6)));
    }

    @Test
    public void shouldComputeMaxPage() throws Exception {
        Assert.assertEquals((String)"less than one page", (long)0L, (long)KeyValueStoreFile.maxPage((int)1024, (int)4, (int)100));
        Assert.assertEquals((String)"exactly one page", (long)0L, (long)KeyValueStoreFile.maxPage((int)1024, (int)4, (int)256));
        Assert.assertEquals((String)"just over one page", (long)1L, (long)KeyValueStoreFile.maxPage((int)1024, (int)4, (int)257));
        Assert.assertEquals((String)"exactly two pages", (long)1L, (long)KeyValueStoreFile.maxPage((int)1024, (int)4, (int)512));
        Assert.assertEquals((String)"over two pages", (long)2L, (long)KeyValueStoreFile.maxPage((int)1024, (int)4, (int)700));
    }

    @Test
    public void shouldFindRecordInPage() throws Exception {
        byte[] key = new byte[1];
        byte[] value = new byte[3];
        DataPage page = new DataPage(4096, 5, 256, key, value){

            @Override
            void writeDataEntry(int record, WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)record);
            }
        };
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)(i + 5), (long)page.findOffset(i));
            Assert.assertEquals((long)i, (long)(key[0] & 0xFF));
        }
    }

    @Test
    public void shouldFindRecordInPageWithDuplicates() throws Exception {
        final byte[] keys = new byte[]{1, 2, 2, 3, 4};
        byte[] key = new byte[1];
        byte[] value = new byte[3];
        DataPage page = new DataPage(4096, 0, 5, key, value){

            @Override
            void writeDataEntry(int record, WritableBuffer key, WritableBuffer value) {
                key.putByte(0, keys[record]);
                value.putByte(0, (byte)record);
            }
        };
        Assert.assertEquals((long)0L, (long)page.findOffset(0));
        Assert.assertEquals((long)0L, (long)(value[0] & 0xFF));
        Assert.assertEquals((long)1L, (long)page.findOffset(1));
        Assert.assertEquals((long)1L, (long)(value[0] & 0xFF));
        Assert.assertEquals((long)1L, (long)page.findOffset(2));
        Assert.assertEquals((long)1L, (long)(value[0] & 0xFF));
        Assert.assertEquals((long)3L, (long)page.findOffset(3));
        Assert.assertEquals((long)3L, (long)(value[0] & 0xFF));
        Assert.assertEquals((long)4L, (long)page.findOffset(4));
        Assert.assertEquals((long)4L, (long)(value[0] & 0xFF));
    }

    @Test(expected=UnderlyingStorageException.class)
    public void shouldThrowOnOutOfBoundsPageAccess() throws Exception {
        final AtomicBoolean goOutOfBounds = new AtomicBoolean();
        byte[] key = new byte[1];
        byte[] value = new byte[3];
        DataPage page = new DataPage(4096, 3, 128, key, value){

            @Override
            void writeDataEntry(int record, WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)66);
            }

            public boolean checkAndClearBoundsFlag() {
                return goOutOfBounds.get() | super.checkAndClearBoundsFlag();
            }
        };
        page.findOffset(0);
        goOutOfBounds.set(true);
        page.findOffset(0);
    }

    @Test
    public void shouldFindFirstRecordGreaterThanIfNoExactMatch() throws Exception {
        byte[] key = new byte[1];
        byte[] value = new byte[3];
        final AtomicInteger delta = new AtomicInteger(1);
        DataPage page = new DataPage(4096, 3, 128, key, value){

            @Override
            void writeDataEntry(int record, WritableBuffer key, WritableBuffer value) {
                key.putByte(0, (byte)(record * 2 + delta.get()));
            }
        };
        delta.set(0);
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((long)(i + 3), (long)page.findOffset(i));
            Assert.assertEquals((long)(i * 2 + 1), (long)(key[0] & 0xFF));
        }
    }

    private static abstract class DataPage
    extends StubPageCursor {
        private final int headerRecords;
        private final int dataRecords;
        private final byte[] key;
        private final byte[] value;

        DataPage(int pageSize, int headerRecords, int dataRecords, byte[] key, byte[] value) {
            super(0L, pageSize);
            int recordSize = key.length + value.length;
            assert ((recordSize & -recordSize) == recordSize) : "invalid usage";
            assert (recordSize * (headerRecords + dataRecords) <= pageSize) : "invalid usage";
            assert (dataRecords <= 1 << key.length * 8) : "invalid usage";
            this.key = key;
            this.value = value;
            this.headerRecords = headerRecords;
            this.dataRecords = dataRecords;
            BigEndianByteArrayBuffer k = new BigEndianByteArrayBuffer(key);
            BigEndianByteArrayBuffer v = new BigEndianByteArrayBuffer(value);
            for (int record = 0; record < dataRecords; ++record) {
                int i;
                this.writeDataEntry(record, (WritableBuffer)k, (WritableBuffer)v);
                for (i = 0; i < key.length; ++i) {
                    this.putByte((record + headerRecords) * recordSize + i, key[i]);
                }
                for (i = 0; i < value.length; ++i) {
                    this.putByte((record + headerRecords) * recordSize + key.length + i, value[i]);
                }
                Arrays.fill(key, (byte)0);
                Arrays.fill(value, (byte)0);
            }
        }

        int findOffset(int key) throws IOException {
            BigEndianByteArrayBuffer searchKey = new BigEndianByteArrayBuffer(this.key.length);
            BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(this.value);
            this.writeDataEntry(key, (WritableBuffer)searchKey, (WritableBuffer)value);
            Arrays.fill(this.value, (byte)0);
            return KeyValueStoreFile.findEntryOffset((PageCursor)this, (BigEndianByteArrayBuffer)searchKey, (BigEndianByteArrayBuffer)new BigEndianByteArrayBuffer(this.key), (BigEndianByteArrayBuffer)value, (int)this.headerRecords, (int)(this.headerRecords + this.dataRecords));
        }

        abstract void writeDataEntry(int var1, WritableBuffer var2, WritableBuffer var3);
    }

    static class CataloguePage {
        final byte first;
        final byte last;

        static int findPage(int key, CataloguePage ... pages) {
            assert (key >= 0 && key <= 255) : "invalid usage";
            byte[] catalogue = new byte[pages.length * 2];
            int min = 0;
            for (int i = 0; i < pages.length; ++i) {
                CataloguePage page = pages[i];
                assert ((page.first & 0xFF) >= min) : "invalid catalogue";
                catalogue[i * 2] = page.first;
                catalogue[i * 2 + 1] = page.last;
                min = page.last & 0xFF;
            }
            return KeyValueStoreFile.findPage((BigEndianByteArrayBuffer)new BigEndianByteArrayBuffer(new byte[]{(byte)key}), (byte[])catalogue);
        }

        static CataloguePage page(int first, int last) {
            assert (first >= 0 && last >= 0 && first <= 255 && last <= 255 && first <= last) : "invalid usage";
            return new CataloguePage((byte)first, (byte)last);
        }

        CataloguePage(byte first, byte last) {
            this.first = first;
            this.last = last;
        }
    }
}

