/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.WritableChannel;

public class LogEntryParserV2_1Test {
    private final LogEntryVersion version = LogEntryVersion.V2_1;
    private final CommandReaderFactory commandReader = new RecordStorageCommandReaderFactory();
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 37L);

    @Test
    public void shouldParseStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(this.version, 1, 2, 3L, 4L, new byte[0], this.position);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.put((byte)1);
        channel.put((byte)2);
        channel.put(new byte[]{42}, 1);
        channel.put(new byte[]{21, 12}, 2);
        channel.putInt(123);
        channel.putInt(456);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)1);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)start, (Object)this.entryOf(logEntry));
        Assert.assertFalse((boolean)parser.skip());
    }

    private LogEntry entryOf(LogEntry logEntry) {
        return logEntry instanceof IdentifiableLogEntry ? ((IdentifiableLogEntry)logEntry).getEntry() : logEntry;
    }

    @Test
    public void shouldParseOnePhaseCommitEntry() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(this.version, 42L, 21L);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)5);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)commit, (Object)this.entryOf(logEntry));
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseTwoPhaseCommitEntryAndMapThemIntoOnePhaseCommit() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(this.version, 42L, 21L);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)6);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)commit, (Object)this.entryOf(logEntry));
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseCommandsUsingAGivenFactory() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand(new NodeRecord(0L), new NodeRecord(0L));
        LogEntryCommand command = new LogEntryCommand(this.version, (StorageCommand)nodeCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(123);
        nodeCommand.serialize((WritableChannel)channel);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)3);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)command, (Object)this.entryOf(logEntry));
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseEmptyEntry() throws IOException {
        LogEntryParser parser = this.version.entryParser((byte)0);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)new InMemoryClosableChannel(), this.marker, this.commandReader);
        Assert.assertNull((Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParsePrepareEntry() throws IOException {
        int nextByte = 7;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(123);
        channel.putLong(456L);
        channel.put((byte)7);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)2);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertNull((Object)logEntry);
        Assert.assertTrue((boolean)parser.skip());
        Assert.assertEquals((long)7L, (long)channel.get());
    }

    @Test
    public void shouldParseDoneEntry() throws IOException {
        int nextByte = 7;
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putInt(123);
        channel.put((byte)7);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)4);
        LogEntry logEntry = parser.parse(this.version, (ReadableClosableChannel)channel, this.marker, this.commandReader);
        Assert.assertNull((Object)logEntry);
        Assert.assertTrue((boolean)parser.skip());
        Assert.assertEquals((long)7L, (long)channel.get());
    }
}

