/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.NodeUpdates;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.StoreViewNodeStoreScan;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class NeoStoreIndexStoreViewTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass());
    private final Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private final Label label = Label.label((String)"Person");
    private GraphDatabaseAPI graphDb;
    private NeoStoreIndexStoreView storeView;
    private int labelId;
    private int propertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private NeoStores neoStores;

    @Before
    public void before() throws KernelException {
        this.graphDb = this.dbRule.getGraphDatabaseAPI();
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.neoStores = ((RecordStorageEngine)this.graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.locks = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)this.locks.acquireNodeLock(Matchers.anyLong(), (LockService.LockType)Matchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArguments()[0];
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, this.neoStores);
    }

    @Test
    public void shouldScanExistingNodesForALabel() throws Exception {
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new NodeUpdates[]{this.add(this.alistair.getId(), this.propertyKeyId, "Alistair", new long[]{this.labelId}), this.add(this.stefan.getId(), this.propertyKeyId, "Stefan", new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    public void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (Visitor)visitor, labelVisitor, false);
        storeScan.run();
        Assert.assertEquals((Object)Iterators.emptySetOf(NodeUpdates.class), visitor.getUpdates());
    }

    @Test
    public void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, visitor, null, false);
        storeScan.run();
        MatcherAssert.assertThat((String)("allocated locks: " + this.lockMocks.keySet()), (Object)this.lockMocks.size(), (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assert.assertNotNull((String)"Lock[node=0] never acquired", (Object)lock0);
        Assert.assertNotNull((String)"Lock[node=1] never acquired", (Object)lock1);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
    }

    @Test
    public void shouldReadProperties() throws EntityNotFoundException {
        Property property = this.storeView.getProperty(this.alistair.getId(), this.propertyKeyId);
        Assert.assertTrue((boolean)property.valueEquals((Object)"Alistair"));
    }

    @Test
    public void processAllNodeProperties() throws Exception {
        CopyUpdateVisitor propertyUpdateVisitor = new CopyUpdateVisitor();
        StoreViewNodeStoreScan storeViewNodeStoreScan = new StoreViewNodeStoreScan(this.neoStores.getNodeStore(), this.locks, this.neoStores.getPropertyStore(), null, (Visitor)propertyUpdateVisitor, new int[]{this.labelId}, id -> true);
        NodeRecord nodeRecord = new NodeRecord(-1L);
        this.neoStores.getNodeStore().getRecord(1L, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE);
        storeViewNodeStoreScan.process(nodeRecord);
        NodeUpdates propertyUpdates = propertyUpdateVisitor.getPropertyUpdates();
        Assert.assertNotNull((String)"Visitor should contain container with updates.", (Object)propertyUpdates);
        LabelSchemaDescriptor index1 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0});
        LabelSchemaDescriptor index2 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor index3 = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0, 1});
        LabelSchemaDescriptor index4 = SchemaDescriptorFactory.forLabel((int)1, (int[])new int[]{1});
        List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index4);
        MatcherAssert.assertThat((Object)Iterables.map(IndexEntryUpdate::indexKey, (Iterable)propertyUpdates.forIndexKeys(indexes)), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new LabelSchemaDescriptor[]{index1, index2, index3}));
    }

    NodeUpdates add(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return NodeUpdates.forNode((long)nodeId, (long[])labels).added(propertyKeyId, value).build();
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = this.graphDb.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = this.graphDb.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            tx.success();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair.delete();
            this.stefan.delete();
            tx.success();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)this.graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = bridge.get();){
                this.labelId = statement.tokenWriteOperations().labelGetOrCreateForName("Person");
                this.propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName("name");
            }
            tx.success();
        }
    }

    class NodeUpdateCollectingVisitor
    implements Visitor<NodeUpdates, Exception> {
        private final Set<NodeUpdates> updates = new HashSet<NodeUpdates>();

        NodeUpdateCollectingVisitor() {
        }

        public boolean visit(NodeUpdates propertyUpdates) throws Exception {
            this.updates.add(propertyUpdates);
            return false;
        }

        Set<NodeUpdates> getUpdates() {
            return this.updates;
        }
    }

    private static class CopyUpdateVisitor
    implements Visitor<NodeUpdates, RuntimeException> {
        private NodeUpdates propertyUpdates;

        private CopyUpdateVisitor() {
        }

        public boolean visit(NodeUpdates element) throws RuntimeException {
            this.propertyUpdates = element;
            return true;
        }

        public NodeUpdates getPropertyUpdates() {
            return this.propertyUpdates;
        }
    }
}

