/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayPageCacheTestSupport;
import org.neo4j.unsafe.impl.batchimport.cache.PageCachedNumberArrayFactory;

@RunWith(value=Parameterized.class)
public class NumberArrayTest
extends NumberArrayPageCacheTestSupport {
    private static NumberArrayPageCacheTestSupport.Fixture fixture;
    private static final int INDEXES = 50000;
    @Rule
    public RandomRule random = new RandomRule();
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public NumberArray<?> array;
    @Parameterized.Parameter(value=2)
    public Function<RandomRule, Object> valueGenerator;
    @Parameterized.Parameter(value=3)
    public Writer writer;
    @Parameterized.Parameter(value=4)
    public Reader reader;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> arrays() throws IOException {
        fixture = NumberArrayTest.prepareDirectoryAndPageCache(NumberArrayTest.class);
        PageCache pageCache = NumberArrayTest.fixture.pageCache;
        File dir = NumberArrayTest.fixture.directory;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        HashMap<String, Object> factories = new HashMap<String, Object>();
        factories.put("HEAP", NumberArrayFactory.HEAP);
        factories.put("OFF_HEAP", NumberArrayFactory.OFF_HEAP);
        factories.put("AUTO_WITHOUT_PAGECACHE", NumberArrayFactory.AUTO_WITHOUT_PAGECACHE);
        factories.put("CHUNKED_FIXED_SIZE", NumberArrayFactory.CHUNKED_FIXED_SIZE);
        factories.put("autoWithPageCacheFallback", NumberArrayFactory.auto((PageCache)pageCache, (File)dir, (boolean)true));
        factories.put("PageCachedNumberArrayFactory", new PageCachedNumberArrayFactory(pageCache, dir));
        for (Map.Entry entry : factories.entrySet()) {
            String name = (String)entry.getKey() + " => ";
            NumberArrayFactory factory = (NumberArrayFactory)entry.getValue();
            list.add(NumberArrayTest.line(name + "IntArray", factory.newIntArray(50000L, -1), random -> random.nextInt(1000000000), (array, index, value) -> array.set((long)index, ((Integer)value).intValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(name + "DynamicIntArray", factory.newDynamicIntArray(500L, -1), random -> random.nextInt(1000000000), (array, index, value) -> array.set((long)index, ((Integer)value).intValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(name + "LongArray", factory.newLongArray(50000L, -1L), random -> random.nextLong(1000000000L), (array, index, value) -> array.set((long)index, ((Long)value).longValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(name + "DynamicLongArray", factory.newDynamicLongArray(500L, -1L), random -> random.nextLong(1000000000L), (array, index, value) -> array.set((long)index, ((Long)value).longValue()), (array, index) -> array.get((long)index)));
            list.add(NumberArrayTest.line(name + "ByteArray", factory.newByteArray(50000L, new byte[]{-1, -1, -1, -1, -1}), random -> random.nextInt(1000000000), (array, index, value) -> array.setInt((long)index, 1, ((Integer)value).intValue()), (array, index) -> array.getInt((long)index, 1)));
            list.add(NumberArrayTest.line(name + "DynamicByteArray", factory.newDynamicByteArray(500L, new byte[]{-1, -1, -1, -1, -1}), random -> random.nextInt(1000000000), (array, index, value) -> array.setInt((long)index, 1, ((Integer)value).intValue()), (array, index) -> array.getInt((long)index, 1)));
        }
        return list;
    }

    private static <N extends NumberArray<N>> Object[] line(String name, N array, Function<RandomRule, Object> valueGenerator, Writer<N> writer, Reader<N> reader) {
        return new Object[]{name, array, valueGenerator, writer, reader};
    }

    @AfterClass
    public static void closeFixture() throws Exception {
        fixture.close();
    }

    @Test
    public void shouldGetAndSetRandomItems() throws Exception {
        HashMap<Integer, Object> key = new HashMap<Integer, Object>();
        Object defaultValue = this.reader.read(this.array, 0);
        for (int i = 0; i < 100000; ++i) {
            int index = this.random.nextInt(50000);
            Object value = this.valueGenerator.apply(this.random);
            this.writer.write(i % 2 == 0 ? this.array : this.array.at((long)index), index, value);
            key.put(index, value);
        }
        for (int index = 0; index < 50000; ++index) {
            Object value = this.reader.read(index % 2 == 0 ? this.array : this.array.at((long)index), index);
            Object expectedValue = key.getOrDefault(index, defaultValue);
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    @After
    public void after() {
        this.array.close();
    }

    @FunctionalInterface
    static interface Reader<N extends NumberArray<N>> {
        public Object read(N var1, int var2);
    }

    @FunctionalInterface
    static interface Writer<N extends NumberArray<N>> {
        public void write(N var1, int var2, Object var3);
    }
}

