/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class LatestCheckPointFinder {
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fileSystem;
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;

    public LatestCheckPointFinder(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader) {
        this.logFiles = logFiles;
        this.fileSystem = fileSystem;
        this.logEntryReader = logEntryReader;
    }

    public LatestCheckPoint find(long fromVersionBackwards) throws IOException {
        PhysicalLogVersionedStoreChannel channel;
        long version = fromVersionBackwards;
        long versionToSearchForCommits = fromVersionBackwards;
        LogEntryStart latestStartEntry = null;
        LogEntryStart oldestStartEntry = null;
        long oldestVersionFound = -1L;
        while (version >= 0L && (channel = PhysicalLogFile.tryOpenForVersion(this.logFiles, this.fileSystem, version, false)) != null) {
            oldestVersionFound = version;
            CheckPoint latestCheckPoint = null;
            ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS);
            boolean firstStartEntry = true;
            try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, recoveredDataChannel);){
                while (cursor.next()) {
                    LogEntry entry = cursor.get();
                    if (entry instanceof CheckPoint) {
                        latestCheckPoint = (CheckPoint)entry.as();
                    }
                    if (!(entry instanceof LogEntryStart)) continue;
                    LogEntryStart startEntry = (LogEntryStart)entry.as();
                    if (version == versionToSearchForCommits) {
                        latestStartEntry = startEntry;
                    }
                    if (!firstStartEntry) continue;
                    oldestStartEntry = startEntry;
                    firstStartEntry = false;
                }
            }
            if (latestCheckPoint != null) {
                return this.latestCheckPoint(fromVersionBackwards, version, latestStartEntry, oldestVersionFound, latestCheckPoint);
            }
            --version;
            if (latestStartEntry != null) continue;
            --versionToSearchForCommits;
        }
        boolean commitsAfterCheckPoint = oldestStartEntry != null;
        long firstTxAfterPosition = commitsAfterCheckPoint ? this.extractFirstTxIdAfterPosition(oldestStartEntry.getStartPosition(), fromVersionBackwards) : LatestCheckPoint.NO_TRANSACTION_ID;
        return new LatestCheckPoint(null, commitsAfterCheckPoint, firstTxAfterPosition, oldestVersionFound);
    }

    protected LatestCheckPoint latestCheckPoint(long fromVersionBackwards, long version, LogEntryStart latestStartEntry, long oldestVersionFound, CheckPoint latestCheckPoint) throws IOException {
        boolean startEntryAfterCheckPoint;
        LogPosition target = latestCheckPoint.getLogPosition();
        boolean bl = startEntryAfterCheckPoint = latestStartEntry != null && latestStartEntry.getStartPosition().compareTo(target) >= 0;
        if (!startEntryAfterCheckPoint && target.getLogVersion() < version) {
            startEntryAfterCheckPoint = this.extractFirstTxIdAfterPosition(target, version) != LatestCheckPoint.NO_TRANSACTION_ID;
        }
        long firstTxIdAfterCheckPoint = startEntryAfterCheckPoint ? this.extractFirstTxIdAfterPosition(target, fromVersionBackwards) : LatestCheckPoint.NO_TRANSACTION_ID;
        return new LatestCheckPoint(latestCheckPoint, startEntryAfterCheckPoint, firstTxIdAfterCheckPoint, oldestVersionFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long extractFirstTxIdAfterPosition(LogPosition initialPosition, long maxLogVersion) throws IOException {
        LogPosition currentPosition = initialPosition;
        while (currentPosition.getLogVersion() <= maxLogVersion) {
            PhysicalLogVersionedStoreChannel storeChannel = PhysicalLogFile.tryOpenForVersion(this.logFiles, this.fileSystem, currentPosition.getLogVersion(), false);
            if (storeChannel != null) {
                try {
                    storeChannel.position(currentPosition.getByteOffset());
                    try (ReadAheadLogChannel logChannel = new ReadAheadLogChannel(storeChannel, LogVersionBridge.NO_MORE_CHANNELS);
                         LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, logChannel);){
                        while (true) {
                            if (cursor.next()) {
                                LogEntry entry = cursor.get();
                                if (!(entry instanceof LogEntryCommit)) continue;
                                long l = ((LogEntryCommit)entry).getTxId();
                                return l;
                                continue;
                            }
                            break;
                        }
                    }
                }
                finally {
                    storeChannel.close();
                }
            }
            currentPosition = LogPosition.start(currentPosition.getLogVersion() + 1L);
        }
        return LatestCheckPoint.NO_TRANSACTION_ID;
    }

    public static class LatestCheckPoint {
        public static long NO_TRANSACTION_ID = -1L;
        public final CheckPoint checkPoint;
        public final boolean commitsAfterCheckPoint;
        public final long firstTxIdAfterLastCheckPoint;
        public final long oldestLogVersionFound;

        public LatestCheckPoint(CheckPoint checkPoint, boolean commitsAfterCheckPoint, long firstTxIdAfterLastCheckPoint, long oldestLogVersionFound) {
            this.checkPoint = checkPoint;
            this.commitsAfterCheckPoint = commitsAfterCheckPoint;
            this.firstTxIdAfterLastCheckPoint = firstTxIdAfterLastCheckPoint;
            this.oldestLogVersionFound = oldestLogVersionFound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatestCheckPoint that = (LatestCheckPoint)o;
            return this.commitsAfterCheckPoint == that.commitsAfterCheckPoint && this.firstTxIdAfterLastCheckPoint == that.firstTxIdAfterLastCheckPoint && this.oldestLogVersionFound == that.oldestLogVersionFound && (this.checkPoint == null ? that.checkPoint == null : this.checkPoint.equals(that.checkPoint));
        }

        public int hashCode() {
            int result = this.checkPoint != null ? this.checkPoint.hashCode() : 0;
            result = 31 * result + (this.commitsAfterCheckPoint ? 1 : 0);
            if (this.commitsAfterCheckPoint) {
                result = 31 * result + Long.hashCode(this.firstTxIdAfterLastCheckPoint);
            }
            result = 31 * result + Long.hashCode(this.oldestLogVersionFound);
            return result;
        }

        public String toString() {
            return "LatestCheckPoint{checkPoint=" + this.checkPoint + ", commitsAfterCheckPoint=" + this.commitsAfterCheckPoint + (this.commitsAfterCheckPoint ? ", firstTxIdAfterLastCheckPoint=" + this.firstTxIdAfterLastCheckPoint : "") + ", oldestLogVersionFound=" + this.oldestLogVersionFound + '}';
        }
    }
}

