/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Iterator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.id.IdRangeIterator;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.ReusableIteratorCostume;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelativeIdRecordAllocator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class PropertyEncoderStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ProcessorStep<Batch<INPUT, RECORD>> {
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder;
    private final int arrayDataSize;
    private final int stringDataSize;
    private final PropertyStore propertyStore;

    protected PropertyEncoderStep(StageControl control, Configuration config, BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyHolder, PropertyStore propertyStore) {
        super(control, "PROPERTIES", config, 0, new StatsProvider[0]);
        this.propertyKeyHolder = propertyKeyHolder;
        this.propertyStore = propertyStore;
        this.arrayDataSize = propertyStore.getArrayStore().getRecordDataSize();
        this.stringDataSize = propertyStore.getStringStore().getRecordDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(Batch<INPUT, RECORD> batch, BatchSender sender) {
        PropertyBlock[] propertyBlocks;
        RelativeIdRecordAllocator stringAllocator = new RelativeIdRecordAllocator(this.stringDataSize);
        RelativeIdRecordAllocator arrayAllocator = new RelativeIdRecordAllocator(this.arrayDataSize);
        BatchingIdSequence relativePropertyRecordIds = new BatchingIdSequence();
        PropertyCreator propertyCreator = new PropertyCreator(stringAllocator, arrayAllocator, relativePropertyRecordIds, null);
        ArrayCollection propertyRecordCollection = new ArrayCollection(4);
        BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
        ReusableIteratorCostume<PropertyBlock> blockIterator = new ReusableIteratorCostume<PropertyBlock>();
        batch.propertyRecords = new PropertyRecord[((InputEntity[])batch.input).length][];
        int totalNumberOfProperties = 0;
        int totalNumberOfPropertyRecords = 0;
        for (int i = 0; i < ((InputEntity[])batch.input).length; ++i) {
            int count;
            InputEntity input = ((InputEntity[])batch.input)[i];
            if (input.hasFirstPropertyId() || (count = input.properties().length >> 1) <= 0) continue;
            propertyBlocks = new PropertyBlock[count];
            this.propertyKeyHolder.propertyKeysAndValues(propertyBlocks, 0, input.properties(), propertyCreator);
            propertyCreator.createPropertyChain(null, blockIterator.dressArray(propertyBlocks, 0, count), propertyRecords, propertyRecordCollection::add);
            batch.propertyRecords[i] = propertyRecordCollection.toArray((R[])new PropertyRecord[propertyRecordCollection.size()]);
            totalNumberOfPropertyRecords += propertyRecordCollection.size();
            totalNumberOfProperties += count;
            propertyRecordCollection.clear();
        }
        propertyBlocks = this.propertyStore;
        synchronized (this.propertyStore) {
            IdRangeIterator propertyRecordsIdRange = PropertyEncoderStep.idRange(totalNumberOfPropertyRecords, this.propertyStore);
            IdRangeIterator dynamicStringRecordsIdRange = PropertyEncoderStep.idRange(Math.toIntExact(stringAllocator.peek()), this.propertyStore.getStringStore());
            IdRangeIterator dynamicArrayRecordsIdRange = PropertyEncoderStep.idRange(Math.toIntExact(arrayAllocator.peek()), this.propertyStore.getArrayStore());
            // ** MonitorExit[propertyBlocks] (shouldn't be in output)
            for (int i = 0; i < ((InputEntity[])batch.input).length; ++i) {
                InputEntity input = ((InputEntity[])batch.input)[i];
                Object record = batch.records[i];
                if (record == null) continue;
                PropertyEncoderStep.reassignPropertyIds(input, record, batch.propertyRecords[i], propertyRecordsIdRange, dynamicStringRecordsIdRange, dynamicArrayRecordsIdRange);
            }
            batch.numberOfProperties = totalNumberOfProperties;
            sender.send(batch);
            return;
        }
    }

    private static IdRangeIterator idRange(int size, IdSequence idSource) {
        return size > 0 ? idSource.nextIdBatch(size).iterator() : IdRangeIterator.EMPTY_ID_RANGE_ITERATOR;
    }

    private static void reassignPropertyIds(InputEntity input, PrimitiveRecord record, PropertyRecord[] propertyRecords, IdRangeIterator propertyRecordsIdRange, IdRangeIterator dynamicStringRecordsIdRange, IdRangeIterator dynamicArrayRecordsIdRange) {
        if (input.hasFirstPropertyId()) {
            record.setNextProp(input.firstPropertyId());
        } else if (propertyRecords != null) {
            PropertyEncoderStep.reassignDynamicRecordIds(dynamicStringRecordsIdRange, dynamicArrayRecordsIdRange, propertyRecords);
            long firstProp = PropertyEncoderStep.reassignPropertyRecordIds(record, propertyRecordsIdRange, propertyRecords);
            record.setNextProp(firstProp);
        }
    }

    private static long reassignPropertyRecordIds(PrimitiveRecord record, IdRangeIterator ids, PropertyRecord[] propertyRecords) {
        long newId;
        long firstId = newId = ids.nextId();
        PropertyRecord prev = null;
        for (PropertyRecord propertyRecord : propertyRecords) {
            record.setIdTo(propertyRecord);
            propertyRecord.setId(newId);
            if (!Record.NO_NEXT_PROPERTY.is(propertyRecord.getNextProp())) {
                newId = ids.nextId();
                propertyRecord.setNextProp(newId);
            }
            if (prev != null) {
                propertyRecord.setPrevProp(prev.getId());
            }
            prev = propertyRecord;
        }
        return firstId;
    }

    private static void reassignDynamicRecordIds(IdRangeIterator stringRecordsIds, IdRangeIterator arrayRecordsIds, PropertyRecord[] propertyRecords) {
        for (PropertyRecord propertyRecord : propertyRecords) {
            for (PropertyBlock block : propertyRecord) {
                PropertyType type = block.getType();
                switch (type) {
                    case STRING: {
                        PropertyEncoderStep.reassignDynamicRecordIds(block, type, stringRecordsIds);
                        break;
                    }
                    case ARRAY: {
                        PropertyEncoderStep.reassignDynamicRecordIds(block, type, arrayRecordsIds);
                        break;
                    }
                }
            }
        }
    }

    private static void reassignDynamicRecordIds(PropertyBlock block, PropertyType type, IdRangeIterator ids) {
        Iterator<DynamicRecord> dynamicRecords = block.getValueRecords().iterator();
        long newId = ids.nextId();
        block.getValueBlocks()[0] = PropertyStore.singleBlockLongValue(block.getKeyIndexId(), type, newId);
        while (dynamicRecords.hasNext()) {
            DynamicRecord dynamicRecord = dynamicRecords.next();
            dynamicRecord.setId(newId);
            if (!dynamicRecords.hasNext()) continue;
            newId = ids.nextId();
            dynamicRecord.setNextBlock(newId);
        }
    }
}

