/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class GraphDatabaseShutdownTest {
    private GraphDatabaseAPI db;

    @Before
    public void setUp() {
        this.db = this.newDb();
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    @Test
    public void transactionShouldReleaseLocksWhenGraphDbIsBeingShutdown() throws Exception {
        Locks locks = (Locks)this.db.getDependencyResolver().resolveDependency(Locks.class);
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
        Exception exceptionThrownByTxClose = null;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            tx.acquireWriteLock((PropertyContainer)node);
            Assert.assertEquals((long)1L, (long)GraphDatabaseShutdownTest.lockCount(locks));
            this.db.shutdown();
            this.db.createNode();
            tx.success();
        }
        catch (Exception e) {
            exceptionThrownByTxClose = e;
        }
        Assert.assertThat((Object)exceptionThrownByTxClose, (Matcher)Matchers.instanceOf(DatabaseShutdownException.class));
        Assert.assertFalse((boolean)this.db.isAvailable(1L));
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
    }

    @Test
    public void shouldBeAbleToShutdownWhenThereAreTransactionsWaitingForLocks() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        CountDownLatch nodeLockedLatch = new CountDownLatch(1);
        Future<Void> shutdownFuture = Executors.newSingleThreadExecutor().submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                node.addLabel(DynamicLabel.label((String)"ABC"));
                nodeLockedLatch.countDown();
                Thread.sleep(1000L);
                this.db.shutdown();
                tx.success();
            }
            return null;
        });
        Future<Void> secondTxResult = Executors.newSingleThreadExecutor().submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                nodeLockedLatch.await();
                node.addLabel(DynamicLabel.label((String)"DEF"));
                tx.success();
            }
            return null;
        });
        try {
            secondTxResult.get(60L, TimeUnit.SECONDS);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        try {
            shutdownFuture.get();
            Assert.fail((String)"Should thrown exception since transaction should be canceled.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    private static int lockCount(Locks locks) {
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        locks.accept((Locks.Visitor)lockCountVisitor);
        return lockCountVisitor.getLockCount();
    }

    private GraphDatabaseAPI newDb() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, "1s").newGraphDatabase();
    }
}

