/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class IndexingAcceptanceTest {
    public static final String LONG_STRING = "a long string that has to be stored in dynamic records";
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    private Label LABEL1;
    private Label LABEL2;
    private Label LABEL3;

    @Test
    public void shouldInterpretPropertyAsChangedEvenIfPropertyMovesFromOneRecordToAnother() throws Exception {
        Node myNode;
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        long smallValue = 10L;
        long bigValue = 0x4000000000000000L;
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.createNode(new Label[]{this.LABEL1});
            myNode.setProperty("pad0", (Object)true);
            myNode.setProperty("pad1", (Object)true);
            myNode.setProperty("pad2", (Object)true);
            myNode.setProperty("key", (Object)smallValue);
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "key");
        tx = beansAPI.beginTx();
        var8_5 = null;
        try {
            myNode.setProperty("key", (Object)bigValue);
            tx.success();
        }
        catch (Throwable throwable) {
            var8_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key", bigValue, (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key", smallValue, (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldUseDynamicPropertiesToIndexANodeWhenAddedAlongsideExistingPropertiesInASeparateTransaction() throws Exception {
        Node myNode;
        long id;
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        try (Transaction tx = beansAPI.beginTx();){
            Node myNode2 = beansAPI.createNode();
            id = myNode2.getId();
            myNode2.setProperty("key0", (Object)true);
            myNode2.setProperty("key1", (Object)true);
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "key2");
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.getNodeById(id);
            myNode.addLabel(this.LABEL1);
            myNode.setProperty("key2", (Object)LONG_STRING);
            myNode.setProperty("key3", (Object)LONG_STRING);
            tx.success();
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("key2").withValue(LONG_STRING)));
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("key3").withValue(LONG_STRING)));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "key2", LONG_STRING, (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingForNodeByPropertyShouldWorkWithoutIndex() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingUsesIndexWhenItExists() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyAtTheSameTime() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL2, "name");
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL3, "name");
        try (Transaction tx = beansAPI.beginTx();){
            myNode.removeLabel(this.LABEL1);
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            tx.success();
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("name").withValue("Einstein")));
        Assert.assertThat(this.labels(myNode), Neo4jMatchers.containsOnly(this.LABEL2, this.LABEL3));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyMultipleTimesAllAtOnce() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL2, "name");
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL3, "name");
        try (Transaction tx = beansAPI.beginTx();){
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            myNode.removeLabel(this.LABEL1);
            myNode.setProperty("name", (Object)"Feynman");
            tx.success();
        }
        Assert.assertThat((Object)myNode, Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, Neo4jMatchers.hasProperty("name").withValue("Feynman")));
        Assert.assertThat(this.labels(myNode), Neo4jMatchers.containsOnly(this.LABEL2, this.LABEL3));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Feynman", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL2, "name", "Feynman", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Einstein", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL3, "name", "Feynman", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(myNode));
    }

    @Test
    public void searchingByLabelAndPropertyReturnsEmptyWhenMissingLabelOrProperty() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Hawking", (GraphDatabaseService)beansAPI), Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldSeeIndexUpdatesWhenQueryingOutsideTransaction() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Mattias", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(firstNode));
        Node secondNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.LABEL1);
        Assert.assertThat(Neo4jMatchers.findNodesByLabelAndProperty(this.LABEL1, "name", "Taylor", (GraphDatabaseService)beansAPI), Neo4jMatchers.containsOnly(secondNode));
    }

    @Test
    public void createdNodeShouldShowUpWithinTransaction() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Transaction tx = beansAPI.beginTx();
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void deletedNodeShouldShowUpWithinTransaction() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void createdNodeShouldShowUpInIndexQuery() throws Exception {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, this.LABEL1, "name");
        this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToQuerySupportedPropertyTypes() throws Exception {
        String property = "name";
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)db, this.LABEL1, property);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, "A String");
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, true);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, false);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, (byte)56);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Character.valueOf('z'));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, (short)12);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12L);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Float.valueOf(12.0f));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12.0);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new String[]{"A String"});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new boolean[]{true});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Boolean[]{false});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new byte[]{56});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Byte[]{(byte)57});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new char[]{'a'});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Character[]{Character.valueOf('b')});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new short[]{12});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Short[]{(short)13});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new int[]{14});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Integer[]{15});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new long[]{16L});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Long[]{17L});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new float[]{18.0f});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Float[]{Float.valueOf(19.0f)});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new double[]{20.0});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Double[]{21.0});
    }

    @Test
    public void shouldRetrieveMultipleNodesWithSameValueFromIndex() throws Exception {
        Node node2;
        Node node1;
        GraphDatabaseAPI graph = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)graph, this.LABEL1, "name");
        try (Transaction tx = graph.beginTx();){
            node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        tx = graph.beginTx();
        var5_3 = null;
        try {
            ResourceIterator result = graph.findNodes(this.LABEL1, "name", (Object)"Stefan");
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2}), (Object)Iterators.asSet((Iterator)result));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(expected=MultipleFoundException.class)
    public void shouldThrowWhenMulitpleResultsForSingleNode() throws Exception {
        GraphDatabaseAPI graph = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)graph, this.LABEL1, "name");
        try (Transaction tx = graph.beginTx();){
            Node node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            Node node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        tx = graph.beginTx();
        var5_3 = null;
        try {
            graph.findNode(this.LABEL1, "name", (Object)"Stefan");
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldAddIndexedPropertyToNodeWithDynamicLabels() {
        long nodeId;
        int indexesCount = 20;
        String labelPrefix = "foo";
        String propertyKeyPrefix = "bar";
        String propertyValuePrefix = "baz";
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        for (int i = 0; i < indexesCount; ++i) {
            Neo4jMatchers.createIndexNoWait((GraphDatabaseService)db, Label.label((String)(labelPrefix + i)), propertyKeyPrefix + i);
        }
        Neo4jMatchers.waitForIndexes((GraphDatabaseService)db);
        try (Transaction tx = db.beginTx();){
            nodeId = db.createNode().getId();
            tx.success();
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            Node node = db.getNodeById(nodeId);
            for (int i = 0; i < indexesCount; ++i) {
                node.addLabel(Label.label((String)(labelPrefix + i)));
                node.setProperty(propertyKeyPrefix + i, (Object)(propertyValuePrefix + i));
            }
            tx.success();
        }
        catch (Throwable node) {
            var9_9 = node;
            throw node;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node) {
                        var9_9.addSuppressed(node);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            for (int i = 0; i < indexesCount; ++i) {
                Label label = Label.label((String)(labelPrefix + i));
                String key = propertyKeyPrefix + i;
                String value = propertyValuePrefix + i;
                ResourceIterator nodes = db.findNodes(label, key, (Object)value);
                Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)nodes));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSupportIndexSeekByPrefix() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IndexNotApplicableKernelException {
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, this.LABEL1, "name");
        this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Mattias", "Mats", "Carla");
        PrimitiveLongSet expected = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Karl", "Karlsson");
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = db.beginTx();
             Statement statement = this.getStatement(db);){
            ReadOperations ops = statement.readOperations();
            IndexDescriptor descriptor = this.indexDescriptor(ops, index);
            int propertyKeyId = descriptor.schema().getPropertyId();
            found.addAll(ops.indexQuery(descriptor, new IndexQuery[]{IndexQuery.stringPrefix((int)propertyKeyId, (String)"Karl")}));
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldIncludeNodesCreatedInSameTxInIndexSeekByPrefix() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IndexNotApplicableKernelException {
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, this.LABEL1, "name");
        this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Mattias", "Mats");
        PrimitiveLongSet expected = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Carl", "Carlsson");
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            expected.add(this.createNode((GraphDatabaseService)db, MapUtil.map((Object[])new Object[]{"name", "Carlchen"}), this.LABEL1).getId());
            this.createNode((GraphDatabaseService)db, MapUtil.map((Object[])new Object[]{"name", "Karla"}), this.LABEL1);
            try (Statement statement = this.getStatement(db);){
                ReadOperations readOperations = statement.readOperations();
                IndexDescriptor descriptor = this.indexDescriptor(readOperations, index);
                int propertyKeyId = descriptor.schema().getPropertyId();
                found.addAll(readOperations.indexQuery(descriptor, new IndexQuery[]{IndexQuery.stringPrefix((int)propertyKeyId, (String)"Carl")}));
            }
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldNotIncludeNodesDeletedInSameTxInIndexSeekByPrefix() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IndexNotApplicableKernelException {
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, this.LABEL1, "name");
        this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Mattias");
        PrimitiveLongSet toDelete = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Karlsson", "Mats");
        PrimitiveLongSet expected = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Karl");
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            for (long id : toDelete) {
                db.getNodeById(id).delete();
                expected.remove(id);
            }
            try (Statement statement = this.getStatement(db);){
                ReadOperations readOperations = statement.readOperations();
                IndexDescriptor descriptor = this.indexDescriptor(readOperations, index);
                int propertyKeyId = descriptor.schema().getPropertyId();
                found.addAll(readOperations.indexQuery(descriptor, new IndexQuery[]{IndexQuery.stringPrefix((int)propertyKeyId, (String)"Karl")}));
            }
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    @Test
    public void shouldConsiderNodesChangedInSameTxInIndexPrefixSearch() throws SchemaRuleNotFoundException, IndexNotFoundKernelException, IndexNotApplicableKernelException {
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, this.LABEL1, "name");
        this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Mattias");
        PrimitiveLongSet toChangeToMatch = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Mats");
        PrimitiveLongSet toChangeToNotMatch = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Karlsson");
        PrimitiveLongSet expected = this.createNodes((GraphDatabaseService)db, this.LABEL1, "name", "Karl");
        String prefix = "Karl";
        PrimitiveLongSet found = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            for (long id : toChangeToMatch) {
                db.getNodeById(id).setProperty("name", (Object)(prefix + "X" + id));
                expected.add(id);
            }
            for (long id : toChangeToNotMatch) {
                db.getNodeById(id).setProperty("name", (Object)("X" + id));
                expected.remove(id);
            }
            try (Statement statement = this.getStatement(db);){
                ReadOperations readOperations = statement.readOperations();
                IndexDescriptor descriptor = this.indexDescriptor(readOperations, index);
                int propertyKeyId = descriptor.schema().getPropertyId();
                found.addAll(readOperations.indexQuery(descriptor, new IndexQuery[]{IndexQuery.stringPrefix((int)propertyKeyId, (String)prefix)}));
            }
        }
        Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)expected));
    }

    private PrimitiveLongSet createNodes(GraphDatabaseService db, Label label, String propertyKey, String ... propertyValues) {
        PrimitiveLongSet expected = Primitive.longSet();
        try (Transaction tx = db.beginTx();){
            for (String value : propertyValues) {
                expected.add(this.createNode(db, MapUtil.map((Object[])new Object[]{propertyKey, value}), label).getId());
            }
            tx.success();
        }
        return expected;
    }

    private IndexDescriptor indexDescriptor(ReadOperations readOperations, IndexDefinition index) throws SchemaRuleNotFoundException {
        int labelId = readOperations.labelGetForName(index.getLabel().name());
        int[] propertyKeyIds = PropertyNameUtils.getPropertyIds((ReadOperations)readOperations, (Iterable)index.getPropertyKeys());
        LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)labelId, (int[])propertyKeyIds);
        return readOperations.indexGetForSchema(descriptor);
    }

    private Statement getStatement(GraphDatabaseAPI db) {
        return ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).get();
    }

    private void assertCanCreateAndFind(GraphDatabaseService db, Label label, String propertyKey, Object value) {
        Node created = this.createNode(db, MapUtil.map((Object[])new Object[]{propertyKey, value}), label);
        try (Transaction tx = db.beginTx();){
            Node found = db.findNode(label, propertyKey, value);
            Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)created));
            found.delete();
            tx.success();
        }
    }

    @Before
    public void setupLabels() {
        this.LABEL1 = Label.label((String)("LABEL1-" + this.testName.getMethodName()));
        this.LABEL2 = Label.label((String)("LABEL2-" + this.testName.getMethodName()));
        this.LABEL3 = Label.label((String)("LABEL3-" + this.testName.getMethodName()));
    }

    private Node createNode(GraphDatabaseService beansAPI, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = beansAPI.beginTx();){
            Node node = beansAPI.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Neo4jMatchers.Deferred<Label> labels(final Node myNode) {
        return new Neo4jMatchers.Deferred<Label>((GraphDatabaseService)dbRule.getGraphDatabaseAPI()){

            @Override
            protected Iterable<Label> manifest() {
                return myNode.getLabels();
            }
        };
    }
}

