/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;

public class GraphDatabaseSettingsTest {
    @Test
    public void mustHaveNullDefaultPageCacheMemorySizeInBytes() throws Exception {
        Long bytes = (Long)Config.defaults().get(GraphDatabaseSettings.pagecache_memory);
        Assert.assertThat((Object)bytes, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void pageCacheSettingMustAcceptArbitraryUserSpecifiedValue() throws Exception {
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        Assert.assertThat((Object)Config.defaults((Setting)setting, (String)"245760").get(setting), (Matcher)Matchers.is((Object)ByteUnit.kibiBytes((long)240L)));
        Assert.assertThat((Object)Config.defaults((Setting)setting, (String)"2244g").get(setting), (Matcher)Matchers.is((Object)ByteUnit.gibiBytes((long)2244L)));
    }

    @Test(expected=InvalidSettingException.class)
    public void pageCacheSettingMustRejectOverlyConstrainedMemorySetting() throws Exception {
        long pageSize = (Long)Config.defaults().get(GraphDatabaseSettings.mapped_memory_page_size);
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        Config.defaults((Setting)setting, (String)("" + (pageSize * 2L - 1L))).get(setting);
    }

    @Test
    public void noDuplicateSettingsAreAllowed() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Field field : GraphDatabaseSettings.class.getDeclaredFields()) {
            if (field.getType() != Setting.class) continue;
            Setting setting = (Setting)field.get(null);
            Assert.assertFalse((String)String.format("'%s' in %s has already been defined in %s", setting.name(), field.getName(), fields.get(setting.name())), (boolean)fields.containsKey(setting.name()));
            fields.put(setting.name(), field.getName());
        }
    }

    @Test
    public void groupToScopeSetting() throws Exception {
        String hostname = "my_other_host";
        int port = 9999;
        String scoping = "bla";
        Map config = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), hostname, new BoltConnector((String)scoping).advertised_address.name(), ":" + port});
        BoltConnector boltConnector = new BoltConnector(scoping);
        Setting advertised_address = boltConnector.advertised_address;
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)advertised_address.apply(config::get);
        Assert.assertEquals((Object)hostname, (Object)advertisedSocketAddress.getHostname());
        Assert.assertEquals((long)port, (long)advertisedSocketAddress.getPort());
    }

    @Test
    public void shouldEnableBoltByDefault() throws Exception {
        Config config = Config.builder().withServerDefaults().build();
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        ListenSocketAddress listenSocketAddress = (ListenSocketAddress)config.get(boltConnector.listen_address);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7687), (Object)listenSocketAddress);
    }

    @Test
    public void shouldBeAbleToDisableBoltConnectorWithJustOneParameter() throws Exception {
        Config config = Config.defaults((Setting)new BoltConnector((String)"bolt").enabled, (String)"false");
        Assert.assertThat((Object)config.boltConnectors().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)config.enabledBoltConnectors(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldBeAbleToOverrideBoltListenAddressesWithJustOneParameter() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldDeriveBoltListenAddressFromDefaultListenAddress() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 7687), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldDeriveBoltListenAddressFromDefaultListenAddressAndSpecifiedPort() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connectors.default_listen_address", "0.0.0.0", "dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldStillSupportCustomNameForBoltConnector() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "BOLT", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":8000"}));
        BoltConnector boltConnector = (BoltConnector)config.boltConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldSupportMultipleBoltConnectorsWithCustomNames() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt1.type", "BOLT", "dbms.connector.bolt1.enabled", "true", "dbms.connector.bolt1.listen_address", ":8000", "dbms.connector.bolt2.type", "BOLT", "dbms.connector.bolt2.enabled", "true", "dbms.connector.bolt2.listen_address", ":9000"}));
        List addresses = config.boltConnectors().stream().map(c -> (ListenSocketAddress)config.get(c.listen_address)).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)addresses.size());
        if (((ListenSocketAddress)addresses.get(0)).getPort() == 8000) {
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), addresses.get(0));
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), addresses.get(1));
        } else {
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), addresses.get(1));
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), addresses.get(0));
        }
    }

    @Test
    public void shouldSupportMultipleBoltConnectorsWithDefaultAndCustomName() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.type", "BOLT", "dbms.connector.bolt.enabled", "true", "dbms.connector.bolt.listen_address", ":8000", "dbms.connector.bolt2.type", "BOLT", "dbms.connector.bolt2.enabled", "true", "dbms.connector.bolt2.listen_address", ":9000"}));
        BoltConnector boltConnector1 = (BoltConnector)config.boltConnectors().get(0);
        BoltConnector boltConnector2 = (BoltConnector)config.boltConnectors().get(1);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(boltConnector1.listen_address));
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), (Object)config.get(boltConnector2.listen_address));
    }

    @Test
    public void testServerDefaultSettings() throws Exception {
        Config config = Config.builder().withServerDefaults().build();
        List connectors = config.httpConnectors();
        Assert.assertEquals((long)2L, (long)connectors.size());
        if (((HttpConnector)connectors.get(0)).encryptionLevel().equals((Object)HttpConnector.Encryption.TLS)) {
            Assert.assertEquals((Object)new ListenSocketAddress("localhost", 7474), (Object)config.get(((HttpConnector)connectors.get((int)1)).listen_address));
            Assert.assertEquals((Object)new ListenSocketAddress("localhost", 7473), (Object)config.get(((HttpConnector)connectors.get((int)0)).listen_address));
        } else {
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7474), (Object)config.get(((HttpConnector)connectors.get((int)0)).listen_address));
            Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 7473), (Object)config.get(((HttpConnector)connectors.get((int)1)).listen_address));
        }
    }

    @Test
    public void shouldBeAbleToDisableHttpConnectorWithJustOneParameter() throws Exception {
        Config disableHttpConfig = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.http.enabled", "false", "dbms.connector.https.enabled", "false"}));
        Assert.assertTrue((boolean)disableHttpConfig.enabledHttpConnectors().isEmpty());
        Assert.assertEquals((long)2L, (long)disableHttpConfig.httpConnectors().size());
    }

    @Test
    public void shouldBeAbleToOverrideHttpListenAddressWithJustOneParameter() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.http.enabled", "true", "dbms.connector.http.listen_address", ":8000"}));
        Assert.assertEquals((long)1L, (long)config.enabledHttpConnectors().size());
        HttpConnector httpConnector = (HttpConnector)config.enabledHttpConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(httpConnector.listen_address));
    }

    @Test
    public void hasDefaultBookmarkAwaitTimeout() {
        Config config = Config.defaults();
        long bookmarkReadyTimeoutMs = ((Duration)config.get(GraphDatabaseSettings.bookmark_ready_timeout)).toMillis();
        Assert.assertEquals((long)TimeUnit.SECONDS.toMillis(30L), (long)bookmarkReadyTimeoutMs);
    }

    @Test
    public void shouldBeAbleToOverrideHttpsListenAddressWithJustOneParameter() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.https.listen_address", ":8000"}));
        Assert.assertEquals((long)1L, (long)config.enabledHttpConnectors().size());
        HttpConnector httpConnector = (HttpConnector)config.enabledHttpConnectors().get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(httpConnector.listen_address));
    }

    @Test
    public void throwsForIllegalBookmarkAwaitTimeout() {
        String[] illegalValues;
        for (String value : illegalValues = new String[]{"0ms", "0s", "10ms", "99ms", "999ms", "42ms"}) {
            try {
                Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.bookmark_ready_timeout.name(), value}));
                config.get(GraphDatabaseSettings.bookmark_ready_timeout);
                Assert.fail((String)("Exception expected for value '" + value + "'"));
            }
            catch (Exception e) {
                Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(InvalidSettingException.class));
            }
        }
    }

    @Test
    public void shouldDeriveListenAddressFromDefaultListenAddress() throws Exception {
        Config config = Config.fromSettings((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.http.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0"})).withServerDefaults().build();
        Assert.assertEquals((long)2L, (long)config.enabledHttpConnectors().size());
        config.enabledHttpConnectors().forEach(c -> Assert.assertEquals((Object)"0.0.0.0", (Object)((ListenSocketAddress)config.get(c.listen_address)).getHostname()));
    }

    @Test
    public void shouldDeriveListenAddressFromDefaultListenAddressAndSpecifiedPorts() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.https.enabled", "true", "dbms.connector.http.enabled", "true", "dbms.connectors.default_listen_address", "0.0.0.0", "dbms.connector.http.listen_address", ":8000", "dbms.connector.https.listen_address", ":9000"}));
        Assert.assertEquals((long)2L, (long)config.enabledHttpConnectors().size());
        config.enabledHttpConnectors().forEach(c -> {
            if (c.key().equals("https")) {
                Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 9000), (Object)config.get(c.listen_address));
            } else {
                Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 8000), (Object)config.get(c.listen_address));
            }
        });
    }

    @Test
    public void shouldStillSupportCustomNameForHttpConnector() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "HTTP", "dbms.connector.random_name_that_will_be_unsupported.encryption", "NONE", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":8000"}));
        Assert.assertEquals((long)1L, (long)config.enabledHttpConnectors().size());
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 8000), (Object)config.get(((HttpConnector)config.enabledHttpConnectors().get((int)0)).listen_address));
    }

    @Test
    public void shouldStillSupportCustomNameForHttpsConnector() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "HTTP", "dbms.connector.random_name_that_will_be_unsupported.encryption", "TLS", "dbms.connector.random_name_that_will_be_unsupported.enabled", "true", "dbms.connector.random_name_that_will_be_unsupported.listen_address", ":9000"}));
        Assert.assertEquals((long)1L, (long)config.enabledHttpConnectors().size());
        Assert.assertEquals((Object)new ListenSocketAddress("127.0.0.1", 9000), (Object)config.get(((HttpConnector)config.enabledHttpConnectors().get((int)0)).listen_address));
    }
}

