/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterators;

public class ArrayUtilTest {
    @Test
    public void shouldProduceUnionOfTwoArrays() throws Exception {
        Object[] first = new String[]{"one", "three"};
        Object[] other = new String[]{"two", "four", "five"};
        Object[] union = (String[])ArrayUtil.union((Object[])first, (Object[])other);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two", "three", "four", "five"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    public void shouldProduceUnionWhereFirstIsNull() throws Exception {
        Object[] first = null;
        Object[] other = new String[]{"one", "two"};
        Object[] union = (String[])ArrayUtil.union(first, (Object[])other);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    public void shouldProduceUnionWhereOtherIsNull() throws Exception {
        Object[] first = new String[]{"one", "two"};
        Object[] other = null;
        Object[] union = (String[])ArrayUtil.union((Object[])first, other);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new String[]{"one", "two"}), (Object)Iterators.asSet((Object[])union));
    }

    @Test
    public void shouldCheckNullSafeEqual() throws Exception {
        Assert.assertTrue((boolean)ArrayUtil.nullSafeEquals(null, null));
        Assert.assertFalse((boolean)ArrayUtil.nullSafeEquals((Object)"1", null));
        Assert.assertFalse((boolean)ArrayUtil.nullSafeEquals(null, (Object)"1"));
        Assert.assertTrue((boolean)ArrayUtil.nullSafeEquals((Object)"1", (Object)"1"));
    }

    @Test
    public void emptyArray() {
        Assert.assertTrue((boolean)ArrayUtil.isEmpty(null));
        Assert.assertTrue((boolean)ArrayUtil.isEmpty((Object[])new String[0]));
        Assert.assertFalse((boolean)ArrayUtil.isEmpty((Object[])new Long[]{1L}));
    }

    @Test
    public void shouldConcatOneAndMany() throws Exception {
        Integer[] result = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4});
        for (int i = 0; i < result.length; ++i) {
            Assert.assertEquals((Object)i, (Object)result[i]);
        }
    }

    @Test
    public void shouldFindIndexOf() throws Exception {
        Object[] numbers = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4, 5});
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((long)i, (long)ArrayUtil.indexOf((Object[])numbers, (Object)i));
        }
    }

    @Test
    public void shouldRemoveItems() throws Exception {
        Object[] numbers = (Integer[])ArrayUtil.concat((Object)0, (Object[])new Integer[]{1, 2, 3, 4, 5});
        Object[] trimmed = (Integer[])ArrayUtil.without((Object[])numbers, (Object[])new Integer[]{2});
        trimmed = (Integer[])ArrayUtil.without((Object[])trimmed, (Object[])new Integer[]{5});
        trimmed = (Integer[])ArrayUtil.without((Object[])trimmed, (Object[])new Integer[]{0});
        Assert.assertEquals((long)3L, (long)trimmed.length);
        Assert.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)0));
        Assert.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)1));
        Assert.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)2));
        Assert.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)3));
        Assert.assertTrue((boolean)ArrayUtil.contains((Object[])trimmed, (Object)4));
        Assert.assertFalse((boolean)ArrayUtil.contains((Object[])trimmed, (Object)5));
    }

    @Test
    public void shouldConcatArrays() throws Exception {
        Object[] initial = new Integer[]{0, 1, 2};
        Object[] all = (Integer[])ArrayUtil.concat((Object[])initial, (Object[])new Integer[]{3, 4, 5});
        Assert.assertArrayEquals((Object[])new Integer[]{0, 1, 2, 3, 4, 5}, (Object[])all);
    }

    @Test
    public void shouldReverseEvenCount() throws Exception {
        Object[] array = new Integer[]{0, 1, 2, 3, 4, 5};
        ArrayUtil.reverse((Object[])array);
        Assert.assertArrayEquals((Object[])new Integer[]{5, 4, 3, 2, 1, 0}, (Object[])array);
    }

    @Test
    public void shouldReverseUnevenCount() throws Exception {
        Object[] array = new Integer[]{0, 1, 2, 3, 4};
        ArrayUtil.reverse((Object[])array);
        Assert.assertArrayEquals((Object[])new Integer[]{4, 3, 2, 1, 0}, (Object[])array);
    }

    @Test
    public void shouldReverseEmptyArray() throws Exception {
        Object[] array = new Integer[]{};
        ArrayUtil.reverse((Object[])array);
        Assert.assertArrayEquals((Object[])new Integer[0], (Object[])array);
    }
}

