/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.helpers.SocketAddressParser;

public class SocketAddressParserTest {
    @Test
    public void shouldCreateAdvertisedSocketAddressWithLeadingWhitespace() throws Exception {
        String addressString = this.whitespace(1) + "localhost:9999";
        SocketAddress address = SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
        Assert.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assert.assertEquals((long)9999L, (long)address.getPort());
    }

    @Test
    public void shouldCreateAdvertisedSocketAddressWithTrailingWhitespace() throws Exception {
        String addressString = "localhost:9999" + this.whitespace(2);
        SocketAddress address = SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
        Assert.assertEquals((Object)"localhost", (Object)address.getHostname());
        Assert.assertEquals((long)9999L, (long)address.getPort());
    }

    @Test
    public void shouldFailToCreateSocketAddressWithMixedInWhitespace() {
        String addressString = "localhost" + this.whitespace(1) + ":9999";
        try {
            SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToCreateSocketWithTrailingNonNumbers() {
        String addressString = "localhost:9999abc";
        try {
            SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailOnMissingPort() {
        String addressString = "localhost:";
        try {
            SocketAddressParser.socketAddress((String)addressString, SocketAddress::new);
            TestCase.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldSupportDomainNameWithPort() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"my.domain:123", SocketAddress::new);
        Assert.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"my.domain:123", (Object)socketAddress.toString());
    }

    @Test
    public void shouldSupportWildcardWithPort() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"0.0.0.0:123", SocketAddress::new);
        Assert.assertEquals((Object)"0.0.0.0", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"0.0.0.0:123", (Object)socketAddress.toString());
        Assert.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportPortOnly() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", (String)":123", (String)"my.domain", (int)456, SocketAddress::new);
        Assert.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"my.domain:123", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportDefaultValue() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"my.domain", (int)456, SocketAddress::new);
        Assert.assertEquals((Object)"my.domain", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)456L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"my.domain:456", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportDefaultWildcard() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"0.0.0.0", (int)456, SocketAddress::new);
        Assert.assertEquals((Object)"0.0.0.0", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)456L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"0.0.0.0:456", (Object)socketAddress.toString());
        Assert.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportDefaultIPv6Wildcard() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"::", (int)456, SocketAddress::new);
        Assert.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)456L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[::]:456", (Object)socketAddress.toString());
        Assert.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportDefaultIPv6Value() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", null, (String)"fe80:1:2::4", (int)456, SocketAddress::new);
        Assert.assertEquals((Object)"fe80:1:2::4", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)456L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[fe80:1:2::4]:456", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldNotUseDefaultsWhenSettingValueSupplied() {
        SocketAddress socketAddress = SocketAddressParser.deriveSocketAddress((String)"setting.name", (String)"[fe80:3:4::6]:456", (String)"fe80:1:2::4", (int)123, SocketAddress::new);
        Assert.assertEquals((Object)"fe80:3:4::6", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)456L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[fe80:3:4::6]:456", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6Wildcard() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[::]:123", SocketAddress::new);
        Assert.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[::]:123", (Object)socketAddress.toString());
        Assert.assertTrue((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6Localhost() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[::1]:123", SocketAddress::new);
        Assert.assertEquals((Object)"::1", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[::1]:123", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6WithZoneId() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[fe80::b279:2f%en0]:123", SocketAddress::new);
        Assert.assertEquals((Object)"fe80::b279:2f%en0", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[fe80::b279:2f%en0]:123", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6AddressWithBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"[fe80:1:2:3:4::5]:123", SocketAddress::new);
        Assert.assertEquals((Object)"fe80:1:2:3:4::5", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[fe80:1:2:3:4::5]:123", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6AddressWithoutBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)"fe80:1:2:3:4::5:123", SocketAddress::new);
        Assert.assertEquals((Object)"fe80:1:2:3:4::5", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[fe80:1:2:3:4::5]:123", (Object)socketAddress.toString());
        Assert.assertFalse((boolean)socketAddress.isWildcard());
    }

    @Test
    public void shouldSupportIPv6WildcardWithoutBrackets() {
        SocketAddress socketAddress = SocketAddressParser.socketAddress((String)":::123", SocketAddress::new);
        Assert.assertEquals((Object)"::", (Object)socketAddress.getHostname());
        Assert.assertEquals((long)123L, (long)socketAddress.getPort());
        Assert.assertEquals((Object)"[::]:123", (Object)socketAddress.toString());
        Assert.assertTrue((boolean)socketAddress.isWildcard());
    }

    private String whitespace(int numberOfWhitespaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfWhitespaces; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

