/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.PlaceboTransaction;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class TestPlaceboTransaction {
    private Transaction placeboTx;
    private Node resource;
    private KernelTransaction kernelTransaction;
    private ReadOperations readOps;

    @Before
    public void before() throws Exception {
        ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)Mockito.mock(ThreadToStatementContextBridge.class);
        Mockito.when((Object)bridge.get()).thenReturn(Mockito.mock(Statement.class));
        this.kernelTransaction = (KernelTransaction)Mockito.spy(KernelTransaction.class);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        this.readOps = (ReadOperations)Mockito.mock(ReadOperations.class);
        Mockito.when((Object)statement.readOperations()).thenReturn((Object)this.readOps);
        Mockito.when((Object)bridge.get()).thenReturn((Object)statement);
        this.placeboTx = new PlaceboTransaction(() -> this.kernelTransaction, (Supplier)bridge);
        this.resource = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.resource.getId()).thenReturn((Object)1L);
    }

    @Test
    public void shouldRollbackParentByDefault() {
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction)).failure();
    }

    @Test
    public void shouldRollbackParentIfFailureCalled() {
        this.placeboTx.failure();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.times((int)2))).failure();
    }

    @Test
    public void shouldNotRollbackParentIfSuccessCalled() {
        this.placeboTx.success();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.times((int)0))).failure();
    }

    @Test
    public void successCannotOverrideFailure() {
        this.placeboTx.failure();
        this.placeboTx.success();
        this.placeboTx.close();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction)).failure();
        ((KernelTransaction)Mockito.verify((Object)this.kernelTransaction, (VerificationMode)Mockito.times((int)0))).success();
    }

    @Test
    public void canAcquireReadLock() throws Exception {
        this.placeboTx.acquireReadLock((PropertyContainer)this.resource);
        ((ReadOperations)Mockito.verify((Object)this.readOps)).acquireShared((ResourceType)ResourceTypes.NODE, new long[]{this.resource.getId()});
    }

    @Test
    public void canAcquireWriteLock() throws Exception {
        this.placeboTx.acquireWriteLock((PropertyContainer)this.resource);
        ((ReadOperations)Mockito.verify((Object)this.readOps)).acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{this.resource.getId()});
    }

    @Test
    public void shouldReturnTerminationReason() {
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)kernelTransaction.getReasonIfTerminated()).thenReturn(Optional.empty()).thenReturn(Optional.of(Status.Transaction.Interrupted));
        PlaceboTransaction tx = new PlaceboTransaction(() -> kernelTransaction, (Supplier)new ThreadToStatementContextBridge());
        Optional terminationReason1 = tx.terminationReason();
        Optional terminationReason2 = tx.terminationReason();
        Assert.assertFalse((boolean)terminationReason1.isPresent());
        Assert.assertTrue((boolean)terminationReason2.isPresent());
        Assert.assertEquals((Object)Status.Transaction.Interrupted, terminationReason2.get());
    }
}

