/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class CompositeIndexingIT {
    public static final int LABEL_ID = 1;
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)200L);
    private final IndexDescriptor index;
    private GraphDatabaseAPI graphDatabaseAPI;

    @Before
    public void setup() throws Exception {
        Throwable throwable;
        Statement statement;
        this.graphDatabaseAPI = dbRule.getGraphDatabaseAPI();
        try (Transaction tx = this.graphDatabaseAPI.beginTx();){
            statement = this.statement();
            throwable = null;
            try {
                if (this.index.type() == IndexDescriptor.Type.UNIQUE) {
                    statement.schemaWriteOperations().uniquePropertyConstraintCreate(this.index.schema());
                } else {
                    statement.schemaWriteOperations().indexCreate(this.index.schema());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
            tx.success();
        }
        var2_2 = null;
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();){
            statement = this.statement();
            throwable = null;
            try {
                while (statement.readOperations().indexGetState(this.index) != InternalIndexState.ONLINE) {
                    Thread.sleep(10L);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var2_2 = throwable6;
            throw throwable6;
        }
    }

    @After
    public void clean() throws Exception {
        try (Transaction tx = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            if (this.index.type() == IndexDescriptor.Type.UNIQUE) {
                statement.schemaWriteOperations().constraintDrop((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.index.schema()));
            } else {
                statement.schemaWriteOperations().indexDrop(this.index);
            }
            tx.success();
        }
        tx = this.graphDatabaseAPI.beginTx();
        var2_2 = null;
        try {
            for (Node node : this.graphDatabaseAPI.getAllNodes()) {
                node.delete();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Parameterized.Parameters(name="Index: {0}")
    public static Iterable<Object[]> parameterValues() throws IOException {
        return Arrays.asList(Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2, 3, 4})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 2})}), Iterators.array((Object[])new IndexDescriptor[]{IndexDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1, 2, 3, 4, 5, 6, 7})}));
    }

    public CompositeIndexingIT(IndexDescriptor nodeDescriptor) {
        this.index = nodeDescriptor;
    }

    @Test
    public void shouldSeeNodeAddedByPropertyToIndexInTranslation() throws Exception {
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            DataWriteOperations writeOperations = statement.dataWriteOperations();
            long nodeID = writeOperations.nodeCreate();
            writeOperations.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                writeOperations.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            PrimitiveLongIterator resultIterator = this.seek(statement);
            MatcherAssert.assertThat((Object)resultIterator.next(), (Matcher)Matchers.equalTo((Object)nodeID));
            Assert.assertFalse((boolean)resultIterator.hasNext());
        }
    }

    @Test
    public void shouldSeeNodeAddedToByLabelIndexInTransaction() throws Exception {
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            DataWriteOperations writeOperations = statement.dataWriteOperations();
            long nodeID = writeOperations.nodeCreate();
            for (int propID : this.index.schema().getPropertyIds()) {
                writeOperations.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            writeOperations.nodeAddLabel(nodeID, 1);
            PrimitiveLongIterator resultIterator = this.seek(statement);
            MatcherAssert.assertThat((Object)resultIterator.next(), (Matcher)Matchers.equalTo((Object)nodeID));
            Assert.assertFalse((boolean)resultIterator.hasNext());
        }
    }

    @Test
    public void shouldNotSeeNodeThatWasDeletedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            statement.dataWriteOperations().nodeDelete(nodeID);
            Assert.assertFalse((boolean)this.seek(statement).hasNext());
        }
    }

    @Test
    public void shouldNotSeeNodeThatHasItsLabelRemovedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            statement.dataWriteOperations().nodeRemoveLabel(nodeID, 1);
            Assert.assertFalse((boolean)this.seek(statement).hasNext());
        }
    }

    @Test
    public void shouldNotSeeNodeThatHasAPropertyRemovedInTransaction() throws Exception {
        long nodeID = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            statement.dataWriteOperations().nodeRemoveProperty(nodeID, this.index.schema().getPropertyIds()[0]);
            Assert.assertFalse((boolean)this.seek(statement).hasNext());
        }
    }

    @Test
    public void shouldSeeAllNodesAddedInTransaction() throws Exception {
        if (this.index.type() != IndexDescriptor.Type.UNIQUE) {
            try (Transaction ignore = this.graphDatabaseAPI.beginTx();
                 Statement statement = this.statement();){
                long nodeID1 = this.createNode();
                long nodeID2 = this.createNode();
                long nodeID3 = this.createNode();
                PrimitiveLongIterator resultIterator = this.seek(statement);
                Set result = PrimitiveLongCollections.toSet((PrimitiveLongIterator)resultIterator);
                MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{nodeID1, nodeID2, nodeID3}));
            }
        }
    }

    @Test
    public void shouldSeeAllNodesAddedBeforeTransaction() throws Exception {
        if (this.index.type() != IndexDescriptor.Type.UNIQUE) {
            long nodeID1 = this.createNode();
            long nodeID2 = this.createNode();
            long nodeID3 = this.createNode();
            try (Transaction ignore = this.graphDatabaseAPI.beginTx();
                 Statement statement = this.statement();){
                PrimitiveLongIterator resultIterator = this.seek(statement);
                Set result = PrimitiveLongCollections.toSet((PrimitiveLongIterator)resultIterator);
                MatcherAssert.assertThat((Object)result, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{nodeID1, nodeID2, nodeID3}));
            }
        }
    }

    @Test
    public void shouldNotSeeNodesLackingOneProperty() throws Exception {
        long nodeID1 = this.createNode();
        try (Transaction ignore = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            DataWriteOperations writeOperations = statement.dataWriteOperations();
            long irrelevantNodeID = writeOperations.nodeCreate();
            writeOperations.nodeAddLabel(irrelevantNodeID, 1);
            for (int i = 0; i < this.index.schema().getPropertyIds().length - 1; ++i) {
                int propID = this.index.schema().getPropertyIds()[i];
                writeOperations.nodeSetProperty(irrelevantNodeID, propID, (Value)Values.intValue((int)propID));
            }
            PrimitiveLongIterator resultIterator = this.seek(statement);
            Set result = PrimitiveLongCollections.toSet((PrimitiveLongIterator)resultIterator);
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.contains((Object[])new Long[]{nodeID1}));
        }
    }

    private long createNode() throws InvalidTransactionTypeKernelException, EntityNotFoundException, ConstraintValidationException, AutoIndexingKernelException {
        long nodeID;
        try (Transaction tx = this.graphDatabaseAPI.beginTx();
             Statement statement = this.statement();){
            DataWriteOperations writeOperations = statement.dataWriteOperations();
            nodeID = writeOperations.nodeCreate();
            writeOperations.nodeAddLabel(nodeID, 1);
            for (int propID : this.index.schema().getPropertyIds()) {
                writeOperations.nodeSetProperty(nodeID, propID, (Value)Values.intValue((int)propID));
            }
            tx.success();
        }
        return nodeID;
    }

    private PrimitiveLongIterator seek(Statement statement) throws IndexNotFoundKernelException, IndexNotApplicableKernelException {
        return statement.readOperations().indexQuery(this.index, this.exactQuery());
    }

    private IndexQuery[] exactQuery() {
        IndexQuery[] query = new IndexQuery[this.index.schema().getPropertyIds().length];
        for (int i = 0; i < query.length; ++i) {
            int propID = this.index.schema().getPropertyIds()[i];
            query[i] = IndexQuery.exact((int)propID, (Object)Values.of((Object)propID));
        }
        return query;
    }

    private Statement statement() {
        return ((ThreadToStatementContextBridge)this.graphDatabaseAPI.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).get();
    }
}

