/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;

public abstract class IndexAccessorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    protected IndexAccessor accessor;

    public IndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Before
    public void before() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator populator = this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig);
        populator.create();
        populator.close(true);
        this.accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);
    }

    @After
    public void after() throws IOException {
        this.accessor.drop();
        this.accessor.close();
    }

    protected List<Long> query(IndexQuery ... predicates) throws Exception {
        return this.metaGet(reader -> reader.query(predicates));
    }

    private List<Long> metaGet(ReaderInteraction interaction) throws Exception {
        try (IndexReader reader = this.accessor.newReader();){
            LinkedList<Long> list = new LinkedList<Long>();
            PrimitiveLongIterator iterator = interaction.results(reader);
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            Collections.sort(list);
            LinkedList<Long> linkedList = list;
            return linkedList;
        }
    }

    void updateAndCommit(List<IndexEntryUpdate<?>> updates) throws IOException, IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
    }

    static interface ReaderInteraction {
        public PrimitiveLongIterator results(IndexReader var1) throws Exception;
    }
}

