/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.SchemaIndexProvider;

public class IndexDirectoryStructureTest {
    private final SchemaIndexProvider.Descriptor provider = new SchemaIndexProvider.Descriptor("test", "0.5");
    private final File databaseStoreDir = new File("db").getAbsoluteFile();
    private final File baseIndexDirectory = IndexDirectoryStructure.baseSchemaIndexFolder((File)this.databaseStoreDir);
    private final long indexId = 15L;

    @Test
    public void shouldSeeCorrectDirectoriesForProviderKey() throws Exception {
        this.assertCorrectDirectories(IndexDirectoryStructure.directoriesByProviderKey((File)this.databaseStoreDir).forProvider(this.provider), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey()}), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey(), String.valueOf(15L)}));
    }

    @Test
    public void shouldSeeCorrectDirectoriesForProvider() throws Exception {
        this.assertCorrectDirectories(IndexDirectoryStructure.directoriesByProvider((File)this.databaseStoreDir).forProvider(this.provider), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey() + "-" + this.provider.getVersion()}), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey() + "-" + this.provider.getVersion(), String.valueOf(15L)}));
    }

    @Test
    public void shouldSeeCorrectDirectoriesForSubProvider() throws Exception {
        IndexDirectoryStructure parentStructure = IndexDirectoryStructure.directoriesByProvider((File)this.databaseStoreDir).forProvider(this.provider);
        SchemaIndexProvider.Descriptor subProvider = new SchemaIndexProvider.Descriptor("sub", "0.3");
        this.assertCorrectDirectories(IndexDirectoryStructure.directoriesBySubProvider((IndexDirectoryStructure)parentStructure).forProvider(subProvider), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey() + "-" + this.provider.getVersion()}), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{this.provider.getKey() + "-" + this.provider.getVersion(), String.valueOf(15L), subProvider.getKey() + "-" + subProvider.getVersion()}));
    }

    @Test
    public void shouldHandleWeirdCharactersInProviderKey() throws Exception {
        SchemaIndexProvider.Descriptor providerWithWeirdName = new SchemaIndexProvider.Descriptor("native+lucene", "1.0");
        this.assertCorrectDirectories(IndexDirectoryStructure.directoriesByProvider((File)this.databaseStoreDir).forProvider(providerWithWeirdName), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{"native_lucene-1.0"}), FileUtils.path((File)this.baseIndexDirectory, (String[])new String[]{"native_lucene-1.0", String.valueOf(15L)}));
    }

    private void assertCorrectDirectories(IndexDirectoryStructure directoryStructure, File expectedRootDirectory, File expectedIndexDirectory) {
        File rootDirectory = directoryStructure.rootDirectory();
        File indexDirectory = directoryStructure.directoryForIndex(15L);
        Assert.assertEquals((Object)expectedRootDirectory, (Object)rootDirectory);
        Assert.assertEquals((Object)expectedIndexDirectory, (Object)indexDirectory);
    }
}

