/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexEntryUpdateTest {
    private final Value[] multiValue = new Value[]{Values.of((Object)"value"), Values.of((Object)"value2")};
    private final Value singleValue = Values.of((Object)"value");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void indexEntryUpdatesShouldBeEqual() {
        IndexEntryUpdate a = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate b = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a.hashCode(), (Matcher)Matchers.equalTo((Object)b.hashCode()));
    }

    @Test
    public void addShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{this.singleValue}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    public void removeShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{this.singleValue}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    public void addShouldThrowIfAskedForChanged() throws Exception {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        this.thrown.expect(UnsupportedOperationException.class);
        single.beforeValues();
    }

    @Test
    public void removeShouldThrowIfAskedForChanged() throws Exception {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        this.thrown.expect(UnsupportedOperationException.class);
        single.beforeValues();
    }

    @Test
    public void updatesShouldEqualRegardlessOfCreationMethod() {
        IndexEntryUpdate singleAdd = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Value[] singleAsArray = new Value[]{this.singleValue};
        IndexEntryUpdate multiAdd = IndexEntryUpdate.add((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleRemove = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multiRemove = IndexEntryUpdate.remove((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)this.singleValue);
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray, (Value[])singleAsArray);
        MatcherAssert.assertThat((Object)singleAdd, (Matcher)Matchers.equalTo((Object)multiAdd));
        MatcherAssert.assertThat((Object)singleRemove, (Matcher)Matchers.equalTo((Object)multiRemove));
        MatcherAssert.assertThat((Object)singleChange, (Matcher)Matchers.equalTo((Object)multiChange));
    }

    @Test
    public void changedShouldRetainValues() throws Exception {
        Value singleAfter = Values.of((Object)"Hello");
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)singleAfter);
        Value[] multiAfter = new Value[]{Values.of((Object)"Hello"), Values.of((Object)"Hi")};
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (LabelSchemaSupplier)SchemaDescriptorFactory.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue, (Value[])multiAfter);
        MatcherAssert.assertThat((Object)new Object[]{this.singleValue}, (Matcher)Matchers.equalTo((Object)singleChange.beforeValues()));
        MatcherAssert.assertThat((Object)new Object[]{singleAfter}, (Matcher)Matchers.equalTo((Object)singleChange.values()));
        MatcherAssert.assertThat((Object)this.multiValue, (Matcher)Matchers.equalTo((Object)multiChange.beforeValues()));
        MatcherAssert.assertThat((Object)multiAfter, (Matcher)Matchers.equalTo((Object)multiChange.values()));
    }
}

