/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexQueryHelper {
    private IndexQueryHelper() {
    }

    public static IndexQuery exact(int propertyKeyId, Object value) {
        return IndexQuery.exact((int)propertyKeyId, (Object)Values.of((Object)value));
    }

    public static IndexEntryUpdate<LabelSchemaDescriptor> add(long nodeId, LabelSchemaDescriptor schema, Object ... objects) {
        return IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)schema, (Value[])IndexQueryHelper.toValues(objects));
    }

    public static IndexEntryUpdate<LabelSchemaDescriptor> remove(long nodeId, LabelSchemaDescriptor schema, Object ... objects) {
        return IndexEntryUpdate.remove((long)nodeId, (LabelSchemaSupplier)schema, (Value[])IndexQueryHelper.toValues(objects));
    }

    public static IndexEntryUpdate<LabelSchemaDescriptor> change(long nodeId, LabelSchemaDescriptor schema, Object o1, Object o2) {
        return IndexEntryUpdate.change((long)nodeId, (LabelSchemaSupplier)schema, (Value)Values.of((Object)o1), (Value)Values.of((Object)o2));
    }

    public static IndexEntryUpdate<LabelSchemaDescriptor> change(long nodeId, LabelSchemaDescriptor schema, Object[] o1, Object[] o2) {
        return IndexEntryUpdate.change((long)nodeId, (LabelSchemaSupplier)schema, (Value[])IndexQueryHelper.toValues(o1), (Value[])IndexQueryHelper.toValues(o2));
    }

    private static Value[] toValues(Object[] objects) {
        Value[] values = new Value[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            values[i] = Values.of((Object)objects[i]);
        }
        return values;
    }
}

