/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodePropertyAccessor
implements PropertyAccessor {
    private final Map<Long, Map<Integer, Value>> nodePropertyMap = new HashMap<Long, Map<Integer, Value>>();

    NodePropertyAccessor(long nodeId, LabelSchemaDescriptor schema, Value ... values) {
        this.addNode(nodeId, schema, values);
    }

    public void addNode(long nodeId, LabelSchemaDescriptor schema, Value ... values) {
        HashMap<Integer, Value> propertyMap = new HashMap<Integer, Value>();
        for (int i = 0; i < schema.getPropertyIds().length; ++i) {
            propertyMap.put(schema.getPropertyIds()[i], values[i]);
        }
        this.nodePropertyMap.put(nodeId, propertyMap);
    }

    public Value getPropertyValue(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        if (this.nodePropertyMap.containsKey(nodeId)) {
            Value value = this.nodePropertyMap.get(nodeId).get(propertyKeyId);
            if (value == null) {
                return Values.NO_VALUE;
            }
            return value;
        }
        return Values.NO_VALUE;
    }
}

