/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying SchemaIndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleIndexPopulatorCompatibility
extends IndexProviderCompatibilityTestSuite.Compatibility {
    public SimpleIndexPopulatorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.create();
            p.markAsFailed(failure);
            p.close(false);
            Assert.assertThat((Object)this.indexProvider.getPopulationFailure(17L), (Matcher)Matchers.containsString((String)failure));
        }));
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.create();
            p.markAsFailed(failure);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(17L, this.descriptor));
        }));
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            p.close(false);
            p.drop();
        }));
    }

    @Test
    public void shouldApplyUpdatesIdempotently() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        Value propertyValue = Values.of((Object)"value1");
        this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            p.create();
            long nodeId = 1L;
            PropertyAccessor propertyAccessor = (nodeId1, propertyKeyId) -> propertyValue;
            p.add(Collections.singletonList(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{propertyValue})));
            try (IndexUpdater updater = p.newPopulatingUpdater(propertyAccessor);){
                updater.process(IndexEntryUpdate.add((long)nodeId, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{propertyValue}));
            }
            p.close(true);
        }));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);){
            try (IndexReader reader = accessor.newReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                PrimitiveLongIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)propertyKeyId, (Object)propertyValue)});
                Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
            }
            accessor.close();
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Unique
    extends SimpleIndexPopulatorCompatibility {
        public Unique(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.uniqueForLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
            Value value = Values.of((Object)"value1");
            int nodeId1 = 1;
            int nodeId2 = 2;
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.create();
                p.add(Arrays.asList(IndexEntryUpdate.add((long)nodeId1, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{value}), IndexEntryUpdate.add((long)nodeId2, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{value})));
                try {
                    NodePropertyAccessor propertyAccessor = new NodePropertyAccessor(nodeId1, this.descriptor.schema(), value);
                    propertyAccessor.addNode(nodeId2, this.descriptor.schema(), value);
                    p.verifyDeferredConstraints((PropertyAccessor)propertyAccessor);
                    Assert.fail((String)"expected exception");
                }
                catch (IndexEntryConflictException conflict) {
                    Assert.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
                    Assert.assertEquals((Object)ValueTuple.of((Value[])new Value[]{value}), (Object)conflict.getPropertyValues());
                    Assert.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
                }
            }));
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class General
    extends SimpleIndexPopulatorCompatibility {
        public General(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, IndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
        }

        @Test
        public void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
            Value value = Values.of((Object)"value1");
            this.withPopulator(this.indexProvider.getPopulator(17L, this.descriptor, indexSamplingConfig), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.create();
                p.add(Arrays.asList(IndexEntryUpdate.add((long)1L, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{value}), IndexEntryUpdate.add((long)2L, (LabelSchemaSupplier)this.descriptor.schema(), (Value[])new Value[]{value})));
                p.close(true);
            }));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(17L, this.descriptor, indexSamplingConfig);){
                try (IndexReader reader = accessor.newReader();){
                    PrimitiveLongIterator nodes = reader.query(new IndexQuery[]{IndexQuery.exact((int)1, (Object)value)});
                    Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)nodes));
                }
                accessor.close();
            }
        }
    }
}

