/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.proc.FieldSignature;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.Neo4jValue;

public class FieldSignatureTest {
    @Test
    public void equalsShouldConsiderName() throws Exception {
        Assert.assertEquals((String)"input without default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        Assert.assertNotEquals((String)"input without default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        Assert.assertEquals((String)"input with default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"hello")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"hello")));
        Assert.assertNotEquals((String)"input with default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"hello")), (Object)FieldSignature.inputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"hello")));
        Assert.assertEquals((String)"output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
        Assert.assertNotEquals((String)"output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
        Assert.assertEquals((String)"deprecated output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true));
        Assert.assertNotEquals((String)"deprecated output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"other", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true));
    }

    @Test
    public void shouldTypeCheckDefaultValue() throws Exception {
        try {
            FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (Neo4jValue)Neo4jValue.ntString((String)"bad"));
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Default value does not have a valid type, field type was INTEGER?, but value type was STRING?.");
        }
    }

    @Test
    public void equalsShouldConsiderType() throws Exception {
        Assert.assertEquals((String)"input without default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString));
        Assert.assertNotEquals((String)"input without default", (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger));
        Assert.assertEquals((String)"output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
        Assert.assertNotEquals((String)"output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (boolean)false));
        Assert.assertEquals((String)"deprecated output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true));
        Assert.assertNotEquals((String)"deprecated output", (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger, (boolean)true));
    }

    @Test
    public void equalsShouldConsiderDefaultValue() throws Exception {
        Assert.assertEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"foo")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"foo")));
        Assert.assertNotEquals((Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"bar")), (Object)FieldSignature.inputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (Neo4jValue)Neo4jValue.ntString((String)"baz")));
    }

    @Test
    public void equalsShouldConsiderDeprecation() throws Exception {
        Assert.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true));
        Assert.assertEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
        Assert.assertNotEquals((Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)true), (Object)FieldSignature.outputField((String)"name", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (boolean)false));
    }
}

