/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.values.storable.Values;

public class IndexQueryTest {
    private final int propId = 0;

    @Test
    public void testExists() throws Exception {
        IndexQuery.ExistsPredicate p = IndexQuery.exists((int)0);
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, "string"));
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, 1));
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, 1.0));
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, true));
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, new long[]{1L}));
        TestCase.assertFalse((boolean)this.test((IndexQuery)p, null));
    }

    @Test
    public void testExact() throws Exception {
        this.assertExactPredicate("string");
        this.assertExactPredicate(1);
        this.assertExactPredicate(1.0);
        this.assertExactPredicate(true);
        this.assertExactPredicate(new long[]{1L});
    }

    private void assertExactPredicate(Object value) {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)0, (Object)value);
        TestCase.assertTrue((boolean)this.test((IndexQuery)p, value));
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testExact_ComparingBigDoublesAndLongs() {
        IndexQuery.ExactPredicate p = IndexQuery.exact((int)0, (Object)0x20000000000001L);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 9.007199254740992E15));
    }

    @Test
    public void testNumRange_FalseForIrrelevant() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testNumRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_ExclusiveLowerExclusiveLower() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 13));
    }

    @Test
    public void testNumRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, (Number)13, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 13));
    }

    @Test
    public void testNumRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)false, (Number)13, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_LowerNullValue() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, null, (boolean)true, (Number)13, (boolean)true);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_UpperNullValue() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)11, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 10));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 11));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 12));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 13));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, 14));
    }

    @Test
    public void testNumRange_ComparingBigDoublesAndLongs() {
        IndexQuery.NumberRangePredicate p = IndexQuery.range((int)0, (Number)0x20000000000001L, (boolean)true, null, (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, 9.007199254740992E15));
    }

    @Test
    public void testStringRange_FalseForIrrelevant() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringRange_InclusiveLowerInclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bee"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "beea"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bef"));
    }

    @Test
    public void testStringRange_ExclusiveLowerInclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)true);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bee"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "beea"));
    }

    @Test
    public void testStringRange_InclusiveLowerExclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)true, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testStringRange_ExclusiveLowerExclusiveUpper() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, (String)"bee", (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testStringRange_UpperUnbounded() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, (String)"bbb", (boolean)false, null, (boolean)false);
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bbb"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bbba"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "xxxxx"));
    }

    @Test
    public void testStringRange_LowerUnbounded() {
        IndexQuery.StringRangePredicate p = IndexQuery.range((int)0, null, (boolean)false, (String)"bee", (boolean)false);
        Assert.assertTrue((boolean)this.test((IndexQuery)p, ""));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bed"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "bee"));
    }

    @Test
    public void testStringPrefix_FalseForIrrelevant() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)0, (String)"dog");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringPrefix_SomeValues() {
        IndexQuery.StringPrefixPredicate p = IndexQuery.stringPrefix((int)0, (String)"dog");
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "doffington"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "doh, not this again!"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "dog"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "doggidog"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "doggidogdog"));
    }

    @Test
    public void testStringContains_FalseForIrrelevant() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)0, (String)"cat");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringContains_SomeValues() {
        IndexQuery.StringContainsPredicate p = IndexQuery.stringContains((int)0, (String)"cat");
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "dog"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "cameraman"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "cat"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "bobcat"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "scatman"));
    }

    @Test
    public void testStringSuffix_FalseForIrrelevant() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)0, (String)"less");
        this.assertFalseForOtherThings((IndexQuery)p);
    }

    @Test
    public void testStringSuffix_SomeValues() {
        IndexQuery.StringSuffixPredicate p = IndexQuery.stringSuffix((int)0, (String)"less");
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "lesser being"));
        Assert.assertFalse((boolean)this.test((IndexQuery)p, "make less noise please..."));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "less"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "clueless"));
        Assert.assertTrue((boolean)this.test((IndexQuery)p, "cluelessly clueless"));
    }

    private void assertFalseForOtherThings(IndexQuery p) {
        TestCase.assertFalse((boolean)this.test(p, "other string"));
        TestCase.assertFalse((boolean)this.test(p, "string1"));
        TestCase.assertFalse((boolean)this.test(p, ""));
        TestCase.assertFalse((boolean)this.test(p, -1));
        TestCase.assertFalse((boolean)this.test(p, -1.0));
        TestCase.assertFalse((boolean)this.test(p, false));
        TestCase.assertFalse((boolean)this.test(p, new long[]{-1L}));
        TestCase.assertFalse((boolean)this.test(p, null));
    }

    private boolean test(IndexQuery p, Object x) {
        return p.test(Values.of((Object)x));
    }
}

