/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;

public class IndexDescriptorFactoryTest {
    private static final int LABEL_ID = 0;

    @Test
    public void shouldCreateIndexDescriptors() {
        IndexDescriptor desc = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateUniqueIndexDescriptors() {
        IndexDescriptor desc = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateIndexDescriptorsFromSchema() {
        IndexDescriptor desc = IndexDescriptorFactory.forSchema((LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.GENERAL));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
        desc = IndexDescriptorFactory.uniqueForSchema((LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1}));
        MatcherAssert.assertThat((Object)desc.type(), (Matcher)Matchers.equalTo((Object)IndexDescriptor.Type.UNIQUE));
        MatcherAssert.assertThat((Object)desc.schema(), (Matcher)Matchers.equalTo((Object)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1})));
    }

    @Test
    public void shouldCreateEqualDescriptors() {
        IndexDescriptor desc1 = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        IndexDescriptor desc2 = IndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
        desc1 = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        desc2 = IndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    public void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)IndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( GENERAL, :Label1(property2) )"));
        MatcherAssert.assertThat((Object)IndexDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4}).userDescription(SchemaTestUtil.simpleNameLookup), (Matcher)Matchers.equalTo((Object)"Index( UNIQUE, :Label2(property4) )"));
    }
}

