/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.builtinprocs.BuiltInDbmsProcedures;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProviderFactory;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.Token;

public class BuiltInProceduresTest {
    private final List<IndexDescriptor> indexes = new LinkedList<IndexDescriptor>();
    private final List<IndexDescriptor> uniqueIndexes = new LinkedList<IndexDescriptor>();
    private final List<ConstraintDescriptor> constraints = new LinkedList<ConstraintDescriptor>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Map<Integer, String> propKeys = new HashMap<Integer, String>();
    private final Map<Integer, String> relTypes = new HashMap<Integer, String>();
    private final ReadOperations read = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final Statement statement = (Statement)Mockito.mock(Statement.class);
    private final KernelTransaction tx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
    private final GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
    private final Procedures procs = new Procedures();
    private final ResourceTracker resourceTracker = new StubResourceManager();
    private static final Key<DependencyResolver> DEPENDENCY_RESOLVER = Key.key((String)"DependencyResolver", DependencyResolver.class);
    private static final Key<GraphDatabaseAPI> GRAPHDATABASEAPI = Key.key((String)"GraphDatabaseAPI", GraphDatabaseAPI.class);

    @Test
    public void shouldListAllIndexes() throws Throwable {
        this.givenIndex("User", "name");
        MatcherAssert.assertThat(this.call("db.indexes", new Object[0]), (Matcher)org.hamcrest.Matchers.contains(this.record("INDEX ON :User(name)", "User", Collections.singletonList("name"), "ONLINE", "node_label_property", this.getIndexProviderDescriptorMap(InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR))));
    }

    private Map<String, String> getIndexProviderDescriptorMap(SchemaIndexProvider.Descriptor providerDescriptor) {
        return MapUtil.stringMap((String[])new String[]{"key", providerDescriptor.getKey(), "version", providerDescriptor.getVersion()});
    }

    @Test
    public void shouldListAllUniqueIndexes() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        MatcherAssert.assertThat(this.call("db.indexes", new Object[0]), (Matcher)org.hamcrest.Matchers.contains(this.record("INDEX ON :User(name)", "User", Collections.singletonList("name"), "ONLINE", "node_unique_property", this.getIndexProviderDescriptorMap(InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR))));
    }

    @Test
    public void shouldListPropertyKeys() throws Throwable {
        this.givenPropertyKeys("name", "age");
        MatcherAssert.assertThat(this.call("db.propertyKeys", new Object[0]), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("age"), this.record("name")}));
    }

    @Test
    public void shouldListLabels() throws Throwable {
        this.givenLabels("Banana", "Fruit");
        MatcherAssert.assertThat(this.call("db.labels", new Object[0]), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("Banana"), this.record("Fruit")}));
    }

    @Test
    public void shouldListRelTypes() throws Throwable {
        this.givenRelationshipTypes("EATS", "SPROUTS");
        MatcherAssert.assertThat(this.call("db.relationshipTypes", new Object[0]), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("EATS"), this.record("SPROUTS")}));
    }

    @Test
    public void shouldListConstraints() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        this.givenNodePropExistenceConstraint("User", "name");
        MatcherAssert.assertThat(this.call("db.constraints", new Object[0]), (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.record("CONSTRAINT ON ( user:User ) ASSERT exists(user.name)"), this.record("CONSTRAINT ON ( user:User ) ASSERT user.name IS UNIQUE")}));
    }

    @Test
    public void shouldEscapeLabelNameContainingColons() throws Throwable {
        this.givenUniqueConstraint("FOO:BAR", "x.y");
        this.givenNodePropExistenceConstraint("FOO:BAR", "x.y");
        List<Object[]> call = this.call("db.constraints", new Object[0]);
        MatcherAssert.assertThat(call, (Matcher)org.hamcrest.Matchers.contains((Matcher[])new Matcher[]{this.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT `foo:bar`.x.y IS UNIQUE"), this.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT exists(`foo:bar`.x.y)")}));
    }

    @Test
    public void shouldListCorrectBuiltinProcedures() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.procedures", new Object[0]), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("dbms.listConfig", "dbms.listConfig(searchString =  :: STRING?) :: (name :: STRING?, description :: STRING?, value :: STRING?)", "List the currently active config of Neo4j."), this.record("db.awaitIndex", "db.awaitIndex(index :: STRING?, timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\"))."), this.record("db.awaitIndexes", "db.awaitIndexes(timeOutSeconds = 300 :: INTEGER?) :: VOID", "Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\"))."), this.record("db.constraints", "db.constraints() :: (description :: STRING?)", "List all constraints in the database."), this.record("db.indexes", "db.indexes() :: (description :: STRING?, label :: STRING?, properties :: LIST? OF STRING?, state :: STRING?, type :: STRING?, provider :: MAP?)", "List all indexes in the database."), this.record("db.labels", "db.labels() :: (label :: STRING?)", "List all labels in the database."), this.record("db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)", "List all property keys in the database."), this.record("db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)", "List all relationship types in the database."), this.record("db.resampleIndex", "db.resampleIndex(index :: STRING?) :: VOID", "Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\"))."), this.record("db.resampleOutdatedIndexes", "db.resampleOutdatedIndexes() :: VOID", "Schedule resampling of all outdated indexes."), this.record("db.schema", "db.schema() :: (nodes :: LIST? OF NODE?, relationships :: LIST? OF RELATIONSHIP?)", "Show the schema of the data."), this.record("db.index.explicit.searchNodes", "db.index.explicit.searchNodes(indexName :: STRING?, query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit index. Replaces `START n=node:nodes('key:foo*')`"), this.record("db.index.explicit.seekNodes", "db.index.explicit.seekNodes(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit index. Replaces `START n=node:nodes(key = 'A')`"), this.record("db.index.explicit.searchRelationships", "db.index.explicit.searchRelationships(indexName :: STRING?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index. Replaces `START r=relationship:relIndex('key:foo*')`"), this.record("db.index.explicit.searchRelationshipsIn", "db.index.explicit.searchRelationshipsIn(indexName :: STRING?, in :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in'."), this.record("db.index.explicit.searchRelationshipsOut", "db.index.explicit.searchRelationshipsOut(indexName :: STRING?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, ending at the node 'out'."), this.record("db.index.explicit.searchRelationshipsBetween", "db.index.explicit.searchRelationshipsBetween(indexName :: STRING?, in :: NODE?, out :: NODE?, query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit index, starting at the node 'in' and ending at 'out'."), this.record("db.index.explicit.seekRelationships", "db.index.explicit.seekRelationships(indexName :: STRING?, key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit index. Replaces `START r=relationship:relIndex(key = 'A')`"), this.record("db.index.explicit.auto.searchNodes", "db.index.explicit.auto.searchNodes(query :: ANY?) :: (node :: NODE?, weight :: FLOAT?)", "Search nodes in explicit automatic index. Replaces `START n=node:node_auto_index('key:foo*')`"), this.record("db.index.explicit.auto.seekNodes", "db.index.explicit.auto.seekNodes(key :: STRING?, value :: ANY?) :: (node :: NODE?)", "Get node from explicit automatic index. Replaces `START n=node:node_auto_index(key = 'A')`"), this.record("db.index.explicit.auto.searchRelationships", "db.index.explicit.auto.searchRelationships(query :: ANY?) :: (relationship :: RELATIONSHIP?, weight :: FLOAT?)", "Search relationship in explicit automatic index. Replaces `START r=relationship:relationship_auto_index('key:foo*')`"), this.record("db.index.explicit.auto.seekRelationships", "db.index.explicit.auto.seekRelationships(key :: STRING?, value :: ANY?) :: (relationship :: RELATIONSHIP?)", "Get relationship from explicit automatic index. Replaces `START r=relationship:relationship_auto_index(key = 'A')`"), this.record("db.index.explicit.addNode", "db.index.explicit.addNode(indexName :: STRING?, node :: NODE?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a node to an explicit index based on a specified key and value"), this.record("db.index.explicit.addRelationship", "db.index.explicit.addRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key :: STRING?, value :: ANY?) :: (success :: BOOLEAN?)", "Add a relationship to an explicit index based on a specified key and value"), this.record("db.index.explicit.removeNode", "db.index.explicit.removeNode(indexName :: STRING?, node :: NODE?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a node from an explicit index with an optional key"), this.record("db.index.explicit.removeRelationship", "db.index.explicit.removeRelationship(indexName :: STRING?, relationship :: RELATIONSHIP?, key =  <[9895b15e-8693-4a21-a58b-4b7b87e09b8e]>  :: STRING?) :: (success :: BOOLEAN?)", "Remove a relationship from an explicit index with an optional key"), this.record("db.index.explicit.drop", "db.index.explicit.drop(indexName :: STRING?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Remove an explicit index - YIELD type,name,config"), this.record("db.index.explicit.forNodes", "db.index.explicit.forNodes(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a node explicit index - YIELD type,name,config"), this.record("db.index.explicit.forRelationships", "db.index.explicit.forRelationships(indexName :: STRING?, config = {} :: MAP?) :: (type :: STRING?, name :: STRING?, config :: MAP?)", "Get or create a relationship explicit index - YIELD type,name,config"), this.record("db.index.explicit.existsForNodes", "db.index.explicit.existsForNodes(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a node explicit index exists"), this.record("db.index.explicit.existsForRelationships", "db.index.explicit.existsForRelationships(indexName :: STRING?) :: (success :: BOOLEAN?)", "Check if a relationship explicit index exists"), this.record("db.index.explicit.list", "db.index.explicit.list() :: (type :: STRING?, name :: STRING?, config :: MAP?)", "List all explicit indexes - YIELD type,name,config"), this.record("dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)", "List DBMS components and their versions."), this.record("dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all procedures in the DBMS."), this.record("dbms.functions", "dbms.functions() :: (name :: STRING?, signature :: STRING?, description :: STRING?)", "List all user functions in the DBMS."), this.record("dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)", "Query JMX management data by domain and name. For instance, \"org.neo4j:*\"")}));
    }

    @Test
    public void shouldListSystemComponents() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.components", new Object[0]), (Matcher)org.hamcrest.Matchers.contains(this.record("Neo4j Kernel", Collections.singletonList("1.3.37"), "enterprise")));
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDbLabels() throws Throwable {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.read.labelsGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.labels", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (ProcedureException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)org.hamcrest.Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDbPropertyKeys() throws Throwable {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.read.propertyKeyGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.propertyKeys", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (ProcedureException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)org.hamcrest.Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    @Test
    public void shouldCloseStatementIfExceptionIsThrownDRelationshipTypes() throws Throwable {
        RuntimeException runtimeException = new RuntimeException();
        Mockito.when((Object)this.read.relationshipTypesGetAllTokens()).thenThrow(new Throwable[]{runtimeException});
        try {
            this.call("db.relationshipTypes", new Object[0]);
            Assert.fail((String)"Procedure call should have failed");
        }
        catch (ProcedureException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)org.hamcrest.Matchers.is((Object)runtimeException));
        }
        ((Statement)Mockito.verify((Object)this.statement)).close();
    }

    private Matcher<Object[]> record(Object ... fields) {
        return org.hamcrest.Matchers.equalTo((Object)fields);
    }

    private void givenIndex(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        IndexDescriptor index = IndexDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propId});
        this.indexes.add(index);
    }

    private void givenUniqueConstraint(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        IndexDescriptor index = IndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propId});
        this.uniqueIndexes.add(index);
        this.constraints.add((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propId}));
    }

    private void givenNodePropExistenceConstraint(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        this.constraints.add((ConstraintDescriptor)ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propId}));
    }

    private void givenPropertyKeys(String ... keys) {
        for (String key : keys) {
            this.token(key, this.propKeys);
        }
    }

    private void givenLabels(String ... labelNames) {
        for (String key : labelNames) {
            this.token(key, this.labels);
        }
    }

    private void givenRelationshipTypes(String ... types) {
        for (String key : types) {
            this.token(key, this.relTypes);
        }
    }

    private Integer token(String name, Map<Integer, String> tokens) {
        Supplier<Integer> allocateFromMap = () -> {
            int newIndex = tokens.size();
            tokens.put(newIndex, name);
            return newIndex;
        };
        return tokens.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(name)).map(Map.Entry::getKey).findFirst().orElseGet(allocateFromMap);
    }

    @Before
    public void setup() throws Exception {
        this.procs.registerComponent(KernelTransaction.class, ctx -> (KernelTransaction)ctx.get(Context.KERNEL_TRANSACTION), false);
        this.procs.registerComponent(DependencyResolver.class, ctx -> (DependencyResolver)ctx.get(DEPENDENCY_RESOLVER), false);
        this.procs.registerComponent(GraphDatabaseAPI.class, ctx -> (GraphDatabaseAPI)ctx.get(GRAPHDATABASEAPI), false);
        this.procs.registerComponent(SecurityContext.class, ctx -> (SecurityContext)ctx.get(Context.SECURITY_CONTEXT), true);
        this.procs.registerType(Node.class, (TypeMappers.NeoValueConverter)new TypeMappers.SimpleConverter((Neo4jTypes.AnyType)Neo4jTypes.NTNode, Node.class));
        this.procs.registerType(Relationship.class, (TypeMappers.NeoValueConverter)new TypeMappers.SimpleConverter((Neo4jTypes.AnyType)Neo4jTypes.NTRelationship, Relationship.class));
        this.procs.registerType(Path.class, (TypeMappers.NeoValueConverter)new TypeMappers.SimpleConverter((Neo4jTypes.AnyType)Neo4jTypes.NTPath, Path.class));
        new SpecialBuiltInProcedures("1.3.37", Edition.enterprise.toString()).accept(this.procs);
        this.procs.registerProcedure(BuiltInProcedures.class);
        this.procs.registerProcedure(BuiltInDbmsProcedures.class);
        Mockito.when((Object)this.tx.acquireStatement()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.statement.readOperations()).thenReturn((Object)this.read);
        Mockito.when((Object)this.read.propertyKeyGetAllTokens()).thenAnswer(this.asTokens(this.propKeys));
        Mockito.when((Object)this.read.labelsGetAllTokens()).thenAnswer(this.asTokens(this.labels));
        Mockito.when((Object)this.read.relationshipTypesGetAllTokens()).thenAnswer(this.asTokens(this.relTypes));
        Mockito.when((Object)this.read.indexesGetAll()).thenAnswer(i -> Iterators.concat((Iterator[])new Iterator[]{this.indexes.iterator(), this.uniqueIndexes.iterator()}));
        Mockito.when((Object)this.read.constraintsGetAll()).thenAnswer(i -> this.constraints.iterator());
        Mockito.when((Object)this.read.proceduresGetAll()).thenReturn((Object)this.procs.getAllProcedures());
        Mockito.when((Object)this.read.propertyKeyGetName(Matchers.anyInt())).thenAnswer(invocation -> this.propKeys.get(invocation.getArguments()[0]));
        Mockito.when((Object)this.read.labelGetName(Matchers.anyInt())).thenAnswer(invocation -> this.labels.get(invocation.getArguments()[0]));
        Mockito.when((Object)this.read.relationshipTypeGetName(Matchers.anyInt())).thenAnswer(invocation -> this.relTypes.get(invocation.getArguments()[0]));
        Mockito.when((Object)this.read.constraintsGetForRelationshipType(Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.indexesGetForLabel(Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.constraintsGetForLabel(Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.countsForNode(Matchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.read.countsForRelationship(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.read.indexGetState((IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.read.indexGetProviderDescriptor((IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)InMemoryIndexProviderFactory.PROVIDER_DESCRIPTOR);
    }

    private Answer<Iterator<Token>> asTokens(Map<Integer, String> tokens) {
        return i -> tokens.entrySet().stream().map(entry -> new Token((String)entry.getValue(), ((Integer)entry.getKey()).intValue())).iterator();
    }

    private List<Object[]> call(String name, Object ... args) throws ProcedureException {
        BasicContext ctx = new BasicContext();
        ctx.put(Context.KERNEL_TRANSACTION, (Object)this.tx);
        ctx.put(DEPENDENCY_RESOLVER, (Object)this.resolver);
        ctx.put(GRAPHDATABASEAPI, (Object)this.graphDatabaseAPI);
        ctx.put(Context.SECURITY_CONTEXT, (Object)SecurityContext.AUTH_DISABLED);
        Mockito.when((Object)this.graphDatabaseAPI.getDependencyResolver()).thenReturn((Object)this.resolver);
        Mockito.when((Object)this.resolver.resolveDependency(Procedures.class)).thenReturn((Object)this.procs);
        return Iterators.asList((RawIterator)this.procs.callProcedure((Context)ctx, ProcedureSignature.procedureName((String[])name.split("\\.")), args, this.resourceTracker));
    }
}

