/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.lang.management.ManagementFactory;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.JmxQueryProcedure;

public class JmxQueryProcedureTest {
    private MBeanServer jmxServer;
    private ObjectName beanName;
    private String attributeName;
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void shouldHandleBasicMBean() throws Throwable {
        Mockito.when((Object)this.jmxServer.getAttribute(this.beanName, "name")).thenReturn((Object)"Hello, world!");
        JmxQueryProcedure procedure = new JmxQueryProcedure(ProcedureSignature.procedureName((String[])new String[]{"bob"}), this.jmxServer);
        RawIterator result = procedure.apply(null, new Object[]{"*:*"}, this.resourceTracker);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)new Object[]{"org.neo4j:chevyMakesTheTruck=bobMcCoshMakesTheDifference", "This is a description", MapUtil.map((Object[])new Object[]{this.attributeName, MapUtil.map((Object[])new Object[]{"description", "This is the attribute desc.", "value", "Hello, world!"})})})));
    }

    @Test
    public void shouldHandleMBeanThatThrowsOnGetAttribute() throws Throwable {
        Mockito.when((Object)this.jmxServer.getAttribute(this.beanName, "name")).thenThrow(new Throwable[]{new RuntimeMBeanException(new UnsupportedOperationException("Haha, screw discoverable services!"))});
        JmxQueryProcedure procedure = new JmxQueryProcedure(ProcedureSignature.procedureName((String[])new String[]{"bob"}), this.jmxServer);
        RawIterator result = procedure.apply(null, new Object[]{"*:*"}, this.resourceTracker);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)new Object[]{"org.neo4j:chevyMakesTheTruck=bobMcCoshMakesTheDifference", "This is a description", MapUtil.map((Object[])new Object[]{this.attributeName, MapUtil.map((Object[])new Object[]{"description", "This is the attribute desc.", "value", null})})})));
    }

    @Test
    public void shouldHandleCompositeAttributes() throws Throwable {
        ObjectName beanName = new ObjectName("org.neo4j:chevyMakesTheTruck=bobMcCoshMakesTheDifference");
        Mockito.when(this.jmxServer.queryNames(new ObjectName("*:*"), null)).thenReturn((Object)Iterators.asSet((Object[])new ObjectName[]{beanName}));
        Mockito.when((Object)this.jmxServer.getMBeanInfo(beanName)).thenReturn((Object)new MBeanInfo("org.neo4j.SomeMBean", "This is a description", new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "differenceMaker", "Who makes the difference?", true, false, false)}, null, null, null));
        Mockito.when((Object)this.jmxServer.getAttribute(beanName, "name")).thenReturn((Object)new CompositeDataSupport(new CompositeType("myComposite", "Composite description", new String[]{"key1", "key2"}, new String[]{"Can't be empty", "Also can't be empty"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER}), MapUtil.map((Object[])new Object[]{"key1", "Hello", "key2", 123})));
        JmxQueryProcedure procedure = new JmxQueryProcedure(ProcedureSignature.procedureName((String[])new String[]{"bob"}), this.jmxServer);
        RawIterator result = procedure.apply(null, new Object[]{"*:*"}, this.resourceTracker);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)result), (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)new Object[]{"org.neo4j:chevyMakesTheTruck=bobMcCoshMakesTheDifference", "This is a description", MapUtil.map((Object[])new Object[]{this.attributeName, MapUtil.map((Object[])new Object[]{"description", "Who makes the difference?", "value", MapUtil.map((Object[])new Object[]{"description", "Composite description", "properties", MapUtil.map((Object[])new Object[]{"key1", "Hello", "key2", 123})})})})})));
    }

    @Test
    public void shouldConvertAllStandardBeansWithoutError() throws Throwable {
        MBeanServer jmxServer = ManagementFactory.getPlatformMBeanServer();
        JmxQueryProcedure procedure = new JmxQueryProcedure(ProcedureSignature.procedureName((String[])new String[]{"bob"}), jmxServer);
        RawIterator result = procedure.apply(null, new Object[]{"*:*"}, this.resourceTracker);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)result).size(), (Matcher)Matchers.equalTo((Object)jmxServer.getMBeanCount()));
    }

    @Before
    public void setup() throws Throwable {
        this.jmxServer = (MBeanServer)Mockito.mock(MBeanServer.class);
        this.beanName = new ObjectName("org.neo4j:chevyMakesTheTruck=bobMcCoshMakesTheDifference");
        this.attributeName = "name";
        Mockito.when(this.jmxServer.queryNames(new ObjectName("*:*"), null)).thenReturn((Object)Iterators.asSet((Object[])new ObjectName[]{this.beanName}));
        Mockito.when((Object)this.jmxServer.getMBeanInfo(this.beanName)).thenReturn((Object)new MBeanInfo("org.neo4j.SomeMBean", "This is a description", new MBeanAttributeInfo[]{new MBeanAttributeInfo(this.attributeName, "someType", "This is the attribute desc.", true, false, false)}, null, null, null));
    }
}

