/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.BoltConnectorValidator;
import org.neo4j.kernel.configuration.Connector;

public class BoltConnectorValidatorTest {
    BoltConnectorValidator cv = new BoltConnectorValidator();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private Consumer<String> warningConsumer;

    @Before
    public void setup() {
        this.warningConsumer = (Consumer)Mockito.mock(Consumer.class);
    }

    @Test
    public void doesNotValidateUnrelatedStuff() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cv.validate(MapUtil.stringMap((String[])new String[]{"dbms.connector.http.enabled", "true", "dbms.blabla.boo", "123"}), this.warningConsumer).size());
    }

    @Test
    public void onlyEnabledRequiredWhenNameIsBolt() throws Exception {
        String boltEnabled = "dbms.connector.bolt.enabled";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{boltEnabled, "true"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{boltEnabled, "true"}), this.warningConsumer));
    }

    @Test
    public void requiresTypeWhenNameIsNotBolt() throws Exception {
        String randomEnabled = "dbms.connector.bla.enabled";
        String randomType = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing mandatory value for 'dbms.connector.bla.type'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true"}), this.warningConsumer);
    }

    @Test
    public void requiresCorrectTypeWhenNameIsNotBolt() throws Exception {
        String randomEnabled = "dbms.connector.bla.enabled";
        String randomType = "dbms.connector.bla.type";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("dbms.connector.bla.type' must be one of BOLT, HTTP; not 'woo'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, "woo"}), this.warningConsumer);
    }

    @Test
    public void warnsWhenNameIsNotBolt() throws Exception {
        String randomEnabled = "dbms.connector.bla.enabled";
        String randomType = "dbms.connector.bla.type";
        this.cv.validate(MapUtil.stringMap((String[])new String[]{randomEnabled, "true", randomType, "BOLT"}), this.warningConsumer);
        ((Consumer)Mockito.verify(this.warningConsumer)).accept(String.format("Warning: connectors with names other than [http,https,bolt] are%ndeprecated and support for them will be removed in a future%nversion of Neo4j. Offending lines in neo4j.conf:%n%n%s", String.format(">  %s%n>  %s%n", randomEnabled, randomType)));
    }

    @Test
    public void errorsOnInvalidConnectorSetting1() throws Exception {
        String invalidSetting = "dbms.connector.bla.0.enabled";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Invalid connector setting: dbms.connector.bla.0.enabled");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{invalidSetting, "true"}), this.warningConsumer);
    }

    @Test
    public void errorsOnInvalidConnectorSetting2() throws Exception {
        String invalidSetting = "dbms.connector.bolt.foobar";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Invalid connector setting: dbms.connector.bolt.foobar");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{invalidSetting, "true"}), this.warningConsumer);
    }

    @Test
    public void validatesTlsLevel() throws Exception {
        String key = "dbms.connector.bolt.tls_level";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.DISABLED.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.DISABLED.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.OPTIONAL.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.OPTIONAL.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.REQUIRED.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.REQUIRED.name()}), this.warningConsumer));
        key = "dbms.connector.bla.tls_level";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.DISABLED.name(), type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.DISABLED.name(), type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.OPTIONAL.name(), type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.OPTIONAL.name(), type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.REQUIRED.name(), type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, BoltConnector.EncryptionLevel.REQUIRED.name(), type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Bad value 'BOBO' for setting 'dbms.connector.bla.tls_level': must be one of [REQUIRED, OPTIONAL, DISABLED] case sensitive");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer);
    }

    @Test
    public void validatesAddress() throws Exception {
        String key = "dbms.connector.bolt.address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer);
    }

    @Test
    public void validatesListenAddress() throws Exception {
        String key = "dbms.connector.bolt.listen_address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.listen_address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.listen_address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer);
    }

    @Test
    public void validatesAdvertisedAddress() throws Exception {
        String key = "dbms.connector.bolt.advertised_address";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123"}), this.warningConsumer));
        key = "dbms.connector.bla.advertised_address";
        String type = "dbms.connector.bla.type";
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        Assert.assertEquals((Object)MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), (Object)this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "localhost:123", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer));
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Setting \"dbms.connector.bla.advertised_address\" must be in the format \"hostname:port\" or \":port\". \"BOBO\" does not conform to these formats");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{key, "BOBO", type, Connector.ConnectorType.BOLT.name()}), this.warningConsumer);
    }

    @Test
    public void validatesType() throws Exception {
        String type = "dbms.connector.bla.type";
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("'dbms.connector.bla.type' must be one of BOLT, HTTP; not 'BOBO'");
        this.cv.validate(MapUtil.stringMap((String[])new String[]{type, "BOBO"}), this.warningConsumer);
    }

    @Test
    public void setsDeprecationFlagOnAddress() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.bolt.address", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.of("dbms.connector.bolt.listen_address"), (Object)setting.replacement());
    }

    @Test
    public void setsDeprecationFlagOnType() throws Exception {
        Setting setting = (Setting)this.cv.getSettingFor("dbms.connector.bolt.type", Collections.emptyMap()).orElseThrow(() -> new RuntimeException("missing setting!"));
        Assert.assertTrue((boolean)setting.deprecated());
        Assert.assertEquals(Optional.empty(), (Object)setting.replacement());
    }

    @Test
    public void setsDeprecationFlagOnCustomNamedBoltConnectors() throws Exception {
        List settings = this.cv.settings(MapUtil.stringMap((String[])new String[]{"dbms.connector.0.type", "BOLT", "dbms.connector.0.enabled", "false", "dbms.connector.0.listen_address", "1.2.3.4:123", "dbms.connector.0.advertised_address", "localhost:123", "dbms.connector.0.tls_level", BoltConnector.EncryptionLevel.OPTIONAL.toString()}));
        Assert.assertEquals((long)5L, (long)settings.size());
        for (Setting s : settings) {
            Assert.assertTrue((String)("every setting should be deprecated: " + s.name()), (boolean)s.deprecated());
            String[] parts = s.name().split("\\.");
            if ("type".equals(parts[3])) continue;
            Assert.assertEquals(Optional.of(String.format("%s.%s.%s.%s", parts[0], parts[1], "bolt", parts[3])), (Object)s.replacement());
        }
    }
}

