/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class SystemTimeZoneLoggingIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void databaseLogsUseSystemTimeZoneIfConfigure() throws IOException {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            this.checkStartLogLine(5, "+0500");
            this.checkStartLogLine(-7, "-0700");
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    private void checkStartLogLine(int hoursShift, String timeZoneSuffix) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.ofHours(hoursShift)));
        File storeDir = this.testDirectory.directory(String.valueOf(hoursShift));
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.log_timezone, LogTimeZone.SYSTEM.name()).newGraphDatabase();
        database.shutdown();
        Path databasePath = storeDir.toPath();
        Path debugLog = Paths.get("logs", "debug.log");
        String debugLogLine = this.getLogLine(databasePath, debugLog);
        Assert.assertTrue((String)debugLogLine, (boolean)debugLogLine.contains(timeZoneSuffix));
    }

    private String getLogLine(Path databasePath, Path logFilePath) throws IOException {
        return Files.readAllLines(databasePath.resolve(logFilePath)).get(0);
    }
}

