/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.guard;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.guard.TerminationGuard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.kernel.impl.locking.StatementLocks;

public class TerminationGuardTest
extends KernelTransactionTestBase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void allowToProceedWhenTransactionIsNotTerminated() {
        TerminationGuard terminationGuard = this.buildGuard();
        KernelTransactionImplementation kernelTransaction = this.getKernelTransaction();
        try (KernelStatement kernelStatement = kernelTransaction.acquireStatement();){
            terminationGuard.check(kernelStatement);
            terminationGuard.check((KernelTransaction)kernelTransaction);
        }
    }

    @Test
    public void throwExceptionWhenCheckTerminatedTransaction() {
        TerminationGuard terminationGuard = this.buildGuard();
        KernelTransactionImplementation kernelTransaction = this.getKernelTransaction();
        kernelTransaction.markForTermination((Status)Status.Transaction.Terminated);
        this.expectedException.expect(TransactionTerminatedException.class);
        terminationGuard.check((KernelTransaction)kernelTransaction);
    }

    @Test
    public void throwExceptionWhenCheckTerminatedStatement() {
        TerminationGuard terminationGuard = this.buildGuard();
        KernelTransactionImplementation kernelTransaction = this.getKernelTransaction();
        try (KernelStatement kernelStatement = kernelTransaction.acquireStatement();){
            kernelTransaction.markForTermination((Status)Status.Transaction.Terminated);
            this.expectedException.expect(TransactionTerminatedException.class);
            terminationGuard.check((KernelTransaction)kernelTransaction);
        }
    }

    private KernelTransactionImplementation getKernelTransaction() {
        KernelTransactionImplementation transaction = this.newNotInitializedTransaction();
        StatementLocks statementLocks = (StatementLocks)Mockito.mock(StatementLocks.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)statementLocks.pessimistic().getLockSessionId()).thenReturn((Object)1);
        transaction.initialize(1L, 2L, statementLocks, KernelTransaction.Type.implicit, SecurityContext.AUTH_DISABLED, 1L);
        return transaction;
    }

    private TerminationGuard buildGuard() {
        return new TerminationGuard();
    }
}

